/*
 * Decompiled with CFR 0.152.
 */
package marytts.vocalizations;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JFrame;
import marytts.machinelearning.KMeansClusteringTrainerParams;
import marytts.machinelearning.PolynomialCluster;
import marytts.machinelearning.PolynomialKMeansClusteringTrainer;
import marytts.signalproc.display.FunctionGraph;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.AudioPlayer;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.math.Polynomial;

public class KMeansClusterer {
    private ArrayList<String> baseNames = new ArrayList();
    Polynomial[] f0Polynomials;
    private int polynomialOrder = 3;
    private int numberOfSamples = 0;
    private int numberOfClusters;
    private HashMap<Polynomial, String> mapPolynomialBaseNames = new HashMap();

    public void loadF0Polynomials(String fileName) throws IOException {
        String line;
        BufferedReader bfr = new BufferedReader(new FileReader(new File(fileName)));
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = bfr.readLine()) != null) {
            lines.add(line.trim());
        }
        String[] words = ((String)lines.get(0)).trim().split("\\s+");
        this.polynomialOrder = words.length - 1;
        this.numberOfSamples = lines.size();
        double[][] f0PolynomialCoeffs = new double[this.numberOfSamples][this.polynomialOrder];
        this.f0Polynomials = new Polynomial[this.numberOfSamples];
        int i = 0;
        while (i < lines.size()) {
            line = (String)lines.get(i);
            words = line.trim().split("\\s+");
            this.baseNames.add(words[0].trim());
            int j = 0;
            while (j < this.polynomialOrder) {
                f0PolynomialCoeffs[i][j] = new Double(words[j + 1].trim());
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.numberOfSamples) {
            this.f0Polynomials[i] = new Polynomial(f0PolynomialCoeffs[i]);
            this.mapPolynomialBaseNames.put(this.f0Polynomials[i], this.baseNames.get(i));
            System.out.print(String.valueOf(this.baseNames.get(i)) + " ");
            int j = 0;
            while (j < this.polynomialOrder) {
                System.out.print(String.valueOf(f0PolynomialCoeffs[i][j]) + " ");
                ++j;
            }
            System.out.println();
            double[] coeff = this.f0Polynomials[i].coeffs;
            System.out.print(String.valueOf(this.baseNames.get(i)) + " ");
            int j2 = 0;
            while (j2 < coeff.length) {
                System.out.print(String.valueOf(coeff[j2]) + " ");
                ++j2;
            }
            System.out.println();
            ++i;
        }
    }

    public void trainer(int numClusters) throws UnsupportedAudioFileException, IOException {
        this.numberOfClusters = numClusters;
        KMeansClusteringTrainerParams params = new KMeansClusteringTrainerParams();
        params.numClusters = numClusters;
        params.maxIterations = 10000;
        PolynomialCluster[] clusters = PolynomialKMeansClusteringTrainer.train(this.f0Polynomials, params);
        FunctionGraph clusterGraph = new FunctionGraph(0.0, 1.0, new double[1]);
        clusterGraph.setYMinMax(-550.0, 500.0);
        clusterGraph.setPrimaryDataSeriesStyle(Color.BLUE, 2, 1);
        JFrame jf = clusterGraph.showInJFrame("", false, true);
        int i = 0;
        while (i < clusters.length) {
            double[] meanValues = clusters[i].getMeanPolynomial().generatePolynomialValues(100, 0.0, 1.0);
            clusterGraph.updateData(0.0, 1.0 / (double)meanValues.length, meanValues);
            Polynomial[] members = clusters[i].getClusterMembers();
            System.out.print("Cluster " + i + " : ");
            int m = 0;
            while (m < members.length) {
                double[] pred = members[m].generatePolynomialValues(meanValues.length, 0.0, 1.0);
                clusterGraph.addDataSeries(pred, Color.GRAY, 1, -1);
                String baseName = this.mapPolynomialBaseNames.get(members[m]);
                System.out.print(String.valueOf(baseName) + " ");
                jf.repaint();
                String waveFile = "/home/sathish/Work/phd/voices/f0desc-listener/vocalizations/wav/" + File.separator + baseName + ".wav";
                AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(waveFile));
                if (!inputAudio.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
                    inputAudio = AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, inputAudio);
                }
                int audioSampleRate = (int)inputAudio.getFormat().getSampleRate();
                AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
                double[] sentenceAudio = signal.getAllData();
                AudioPlayer ap = new AudioPlayer(new DDSAudioInputStream(new BufferedDoubleDataSource(sentenceAudio), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioSampleRate, 16, 1, 2, audioSampleRate, true)));
                ap.start();
                try {
                    ap.join();
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
                ++m;
            }
            System.out.println();
            jf.setTitle("Cluster " + (i + 1) + " of " + clusters.length + ": " + members.length + " members");
            jf.repaint();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
    }

    public static void main(String[] args) throws IOException, UnsupportedAudioFileException {
        KMeansClusterer kmc = new KMeansClusterer();
        String fileName = "/home/sathish/phd/voices/en-GB-listener/yeahPrudenceVocalizationF0PolyFeatureFile.txt";
        kmc.loadF0Polynomials(fileName);
        kmc.trainer(5);
        System.exit(0);
    }
}

