/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data.text;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import marytts.util.data.text.TextReaderDoubleDataSource;

public class SnackTextfileDoubleDataSource
extends TextReaderDoubleDataSource {
    public SnackTextfileDoubleDataSource(File file) throws FileNotFoundException {
        this(new FileReader(file));
    }

    public SnackTextfileDoubleDataSource(Reader reader) {
        super(reader);
    }

    @Override
    public int getData(double[] target, int targetPos, int length) {
        int i = 0;
        try {
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = this.reader.readLine()) != null) {
                lines.add(line);
            }
            int numData = lines.size();
            i = 0;
            while (i < length) {
                if (i >= numData) {
                    return i;
                }
                String strVal = (String)lines.get(i);
                StringTokenizer s = new StringTokenizer(strVal);
                double value = s.hasMoreTokens() ? Double.parseDouble(s.nextToken()) : Double.parseDouble(strVal);
                target[targetPos + i] = value;
                ++i;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return i;
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            return i;
        }
        return length;
    }
}

