/*
 * Decompiled with CFR 0.152.
 */
package marytts.tools.install;

import java.awt.Font;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import marytts.tools.install.ComponentDescription;
import org.jdesktop.layout.GroupLayout;

public class ProgressPanel
extends JPanel
implements Runnable,
Observer {
    private List<ComponentDescription> allComponents;
    private ComponentDescription currentComponent = null;
    private boolean install;
    private boolean exitRequested = false;
    private JLabel lName;
    private JLabel lNameValue;
    private JLabel lStatus;
    private JLabel lStatusValue;
    private JPanel pCurrent;
    private JPanel pOverall;
    private JProgressBar pbCurrent;
    private JProgressBar pbOverall;

    public ProgressPanel(List<ComponentDescription> componentsToProcess, boolean install) {
        this.allComponents = componentsToProcess;
        this.install = install;
        this.initComponents();
    }

    public synchronized void requestExit() {
        this.exitRequested = true;
        if (this.currentComponent != null) {
            this.currentComponent.cancel();
        }
    }

    private synchronized boolean isExitRequested() {
        return this.exitRequested;
    }

    private void setCurrentComponent(ComponentDescription desc) {
        if (this.currentComponent != null) {
            this.currentComponent.deleteObserver(this);
        }
        this.currentComponent = desc;
        if (this.currentComponent != null) {
            this.currentComponent.addObserver(this);
        }
        this.verifyCurrentComponentDisplay();
    }

    private void initComponents() {
        this.pCurrent = new JPanel();
        this.lName = new JLabel();
        this.lNameValue = new JLabel();
        this.lStatus = new JLabel();
        this.lStatusValue = new JLabel();
        this.pbCurrent = new JProgressBar();
        this.pOverall = new JPanel();
        this.pbOverall = new JProgressBar();
        this.pCurrent.setBorder(BorderFactory.createTitledBorder("Current component"));
        this.lName.setFont(new Font("Lucida Grande", 1, 13));
        this.lName.setText("Name:");
        this.lNameValue.setText(this.currentComponent != null ? this.currentComponent.getName() : "");
        this.lStatus.setFont(new Font("Lucida Grande", 1, 13));
        this.lStatus.setText("Status:");
        this.lStatusValue.setText(this.currentComponent != null ? this.currentComponent.getStatus().toString() : "");
        this.pbCurrent.setStringPainted(true);
        GroupLayout pCurrentLayout = new GroupLayout(this.pCurrent);
        this.pCurrent.setLayout(pCurrentLayout);
        pCurrentLayout.setHorizontalGroup(pCurrentLayout.createParallelGroup(1).add(pCurrentLayout.createSequentialGroup().add(pCurrentLayout.createParallelGroup(1).add(pCurrentLayout.createSequentialGroup().add(this.lName).addPreferredGap(0).add(this.lNameValue)).add(pCurrentLayout.createSequentialGroup().add(this.lStatus).addPreferredGap(0).add(this.lStatusValue).addPreferredGap(0, 50, Short.MAX_VALUE).add(this.pbCurrent, -2, 184, -2))).addContainerGap()));
        pCurrentLayout.setVerticalGroup(pCurrentLayout.createParallelGroup(1).add(pCurrentLayout.createSequentialGroup().add(pCurrentLayout.createParallelGroup(1).add(pCurrentLayout.createSequentialGroup().add(pCurrentLayout.createParallelGroup(3).add(this.lName).add(this.lNameValue)).add(16, 16, 16).add(pCurrentLayout.createParallelGroup(3).add(this.lStatus).add(this.lStatusValue))).add(pCurrentLayout.createSequentialGroup().add(27, 27, 27).add(this.pbCurrent, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.pOverall.setBorder(BorderFactory.createTitledBorder("Overall progress"));
        this.pbOverall.setString("");
        this.pbOverall.setStringPainted(true);
        GroupLayout pOverallLayout = new GroupLayout(this.pOverall);
        this.pOverall.setLayout(pOverallLayout);
        pOverallLayout.setHorizontalGroup(pOverallLayout.createParallelGroup(1).add(2, pOverallLayout.createSequentialGroup().addContainerGap().add(this.pbOverall, -1, 352, Short.MAX_VALUE).addContainerGap()));
        pOverallLayout.setVerticalGroup(pOverallLayout.createParallelGroup(1).add(2, pOverallLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add(this.pbOverall, -2, -1, -2).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(this.pCurrent, -1, -1, Short.MAX_VALUE).add(this.pOverall, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.pCurrent, -2, -1, -2).addPreferredGap(0).add(this.pOverall, -2, -1, -2)));
    }

    @Override
    public void run() {
        boolean error = false;
        ComponentDescription problematic = null;
        int i = 0;
        int max = this.allComponents.size();
        this.pbOverall.setMaximum(max);
        String action = this.install ? "install" : "uninstall";
        for (ComponentDescription comp : this.allComponents) {
            if (this.isExitRequested()) {
                return;
            }
            System.out.println("Now " + action + "ing " + comp.getName() + "...");
            this.pbOverall.setValue(i);
            this.pbOverall.setString(String.valueOf(i) + " / " + max);
            this.setCurrentComponent(comp);
            if (this.install) {
                if (comp.getStatus() == ComponentDescription.Status.INSTALLED) {
                    assert (comp.isUpdateAvailable());
                    comp.uninstall();
                    if (comp.getStatus() == ComponentDescription.Status.ERROR) {
                        error = true;
                    } else if (comp.isUpdateAvailable()) {
                        comp.replaceWithUpdate();
                    }
                }
                if (!error && comp.getStatus() == ComponentDescription.Status.AVAILABLE || comp.getStatus() == ComponentDescription.Status.CANCELLED) {
                    comp.download(true);
                    if (comp.getStatus() == ComponentDescription.Status.ERROR) {
                        error = true;
                    }
                }
                if (!error && comp.getStatus() == ComponentDescription.Status.DOWNLOADED) {
                    try {
                        comp.install(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        error = true;
                    }
                    if (comp.getStatus() == ComponentDescription.Status.ERROR) {
                        error = true;
                    }
                }
            } else if (comp.getStatus() == ComponentDescription.Status.INSTALLED) {
                comp.uninstall();
                if (comp.getStatus() == ComponentDescription.Status.ERROR) {
                    error = true;
                } else if (comp.isUpdateAvailable()) {
                    comp.replaceWithUpdate();
                }
            }
            if (error) {
                problematic = comp;
                System.err.println("Could not " + action + " " + comp.getName());
                break;
            }
            comp.setSelected(false);
            ++i;
        }
        if (error) {
            assert (problematic != null);
            JOptionPane.showMessageDialog(this, "Could not " + action + " " + problematic.getName());
        } else {
            this.pbOverall.setValue(max);
            this.pbOverall.setString(String.valueOf(max) + " / " + max);
        }
        this.setCurrentComponent(null);
        this.getTopLevelAncestor().setVisible(false);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o != this.currentComponent) {
            throw new IllegalStateException("We are observing " + o + " but the currentComponent is " + this.currentComponent);
        }
        this.verifyCurrentComponentDisplay();
    }

    private void verifyCurrentComponentDisplay() {
        if (this.currentComponent == null) {
            return;
        }
        this.lNameValue.setText(this.currentComponent.getName());
        this.lStatusValue.setText(this.currentComponent.getStatus().toString());
        int progress = this.currentComponent.getProgress();
        if (progress < 0) {
            this.pbCurrent.setIndeterminate(true);
        } else {
            this.pbCurrent.setIndeterminate(false);
            this.pbCurrent.setValue(progress);
        }
    }
}

