/*
 * Decompiled with CFR 0.152.
 */
package marytts.tools.install;

import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import marytts.Version;
import marytts.tools.install.ComponentDescription;
import marytts.tools.install.InstallFileParser;
import marytts.tools.install.LanguageComponentDescription;
import marytts.tools.install.LicensePanel;
import marytts.tools.install.LicenseRegistry;
import marytts.tools.install.PasswordPanel;
import marytts.tools.install.ProgressPanel;
import marytts.tools.install.ProxyPanel;
import marytts.tools.install.ShortDescriptionPanel;
import marytts.tools.install.VoiceComponentDescription;
import marytts.tools.install.VoiceUpdateListener;
import marytts.util.MaryUtils;
import org.jdesktop.layout.GroupLayout;

public class InstallerGUI
extends JFrame
implements VoiceUpdateListener {
    private Map<String, LanguageComponentDescription> languages;
    private Map<String, VoiceComponentDescription> voices;
    private LanguageComponentDescription currentLanguage = null;
    private String version = Version.specificationVersion();
    private JButton bInstall;
    private JButton bUninstall;
    private JButton bUninstall1;
    private JButton bUpdate;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JMenuBar menuBar1;
    private JMenu menuTools1;
    private JMenuItem miProxy1;
    private JPanel pDownload;
    private JPanel pInstallButtons;
    private JPanel pLanguages;
    private JPanel pVoices;
    private JScrollPane spLanguages;
    private JScrollPane spVoices;
    private JTextField tfComponentListURL;

    public InstallerGUI() {
        this((String)null);
    }

    public InstallerGUI(String maryComponentURL) {
        this.languages = new TreeMap<String, LanguageComponentDescription>();
        this.voices = new TreeMap<String, VoiceComponentDescription>();
        this.initComponents();
        this.customInitComponents();
        if (maryComponentURL != null) {
            this.setAndUpdateFromMaryComponentURL(maryComponentURL);
        }
    }

    public void setAndUpdateFromMaryComponentURL(String maryComponentURL) {
        try {
            new URL(maryComponentURL);
            this.tfComponentListURL.setText(maryComponentURL);
            this.updateFromMaryComponentURL();
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public void addLanguagesAndVoices(InstallFileParser p) {
        ComponentDescription existing;
        for (LanguageComponentDescription languageComponentDescription : p.getLanguageDescriptions()) {
            if (this.languages.containsKey(languageComponentDescription.getName())) {
                existing = this.languages.get(languageComponentDescription.getName());
                if (existing.getStatus() == ComponentDescription.Status.INSTALLED) {
                    if (!languageComponentDescription.isUpdateOf(existing)) continue;
                    existing.setAvailableUpdate(languageComponentDescription);
                    continue;
                }
                if (languageComponentDescription.getStatus() == ComponentDescription.Status.INSTALLED) {
                    this.languages.put(languageComponentDescription.getName(), languageComponentDescription);
                    if (!existing.isUpdateOf(languageComponentDescription)) continue;
                    languageComponentDescription.setAvailableUpdate(existing);
                    continue;
                }
                if (!ComponentDescription.isVersionNewerThan(languageComponentDescription.getVersion(), existing.getVersion())) continue;
                this.languages.put(languageComponentDescription.getName(), languageComponentDescription);
                continue;
            }
            this.languages.put(languageComponentDescription.getName(), languageComponentDescription);
        }
        for (VoiceComponentDescription voiceComponentDescription : p.getVoiceDescriptions()) {
            if (this.voices.containsKey(voiceComponentDescription.getName())) {
                existing = this.voices.get(voiceComponentDescription.getName());
                if (existing.getStatus() == ComponentDescription.Status.INSTALLED) {
                    if (!voiceComponentDescription.isUpdateOf(existing)) continue;
                    existing.setAvailableUpdate(voiceComponentDescription);
                    continue;
                }
                if (voiceComponentDescription.getStatus() == ComponentDescription.Status.INSTALLED) {
                    this.voices.put(voiceComponentDescription.getName(), voiceComponentDescription);
                    if (!existing.isUpdateOf(voiceComponentDescription)) continue;
                    voiceComponentDescription.setAvailableUpdate(existing);
                    continue;
                }
                if (!ComponentDescription.isVersionNewerThan(voiceComponentDescription.getVersion(), existing.getVersion())) continue;
                this.voices.put(voiceComponentDescription.getName(), voiceComponentDescription);
                continue;
            }
            this.voices.put(voiceComponentDescription.getName(), voiceComponentDescription);
        }
        this.updateLanguagesTable();
    }

    private void initComponents() {
        this.pDownload = new JPanel();
        this.tfComponentListURL = new JTextField();
        this.bUpdate = new JButton();
        this.pInstallButtons = new JPanel();
        this.bInstall = new JButton();
        this.bUninstall = new JButton();
        this.bUninstall1 = new JButton();
        this.jPanel1 = new JPanel();
        this.spLanguages = new JScrollPane();
        this.pLanguages = new JPanel();
        this.spVoices = new JScrollPane();
        this.pVoices = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.menuBar1 = new JMenuBar();
        this.menuTools1 = new JMenu();
        this.miProxy1 = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setTitle("MARY TTS Installer");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                InstallerGUI.this.windowClosing(evt);
            }
        });
        this.pDownload.setBorder(BorderFactory.createTitledBorder("Download languages and voices from:"));
        if (this.version.equals("trunk")) {
            this.version = "latest";
        }
        this.tfComponentListURL.setText("https://raw.github.com/marytts/marytts/master/download/marytts-components.xml");
        this.tfComponentListURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstallerGUI.this.tfComponentListURLActionPerformed(evt);
            }
        });
        this.bUpdate.setText("Update");
        this.bUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstallerGUI.this.bUpdateActionPerformed(evt);
            }
        });
        GroupLayout pDownloadLayout = new GroupLayout(this.pDownload);
        this.pDownload.setLayout(pDownloadLayout);
        pDownloadLayout.setHorizontalGroup(pDownloadLayout.createParallelGroup(1).add(pDownloadLayout.createSequentialGroup().add(this.tfComponentListURL, -2, 540, -2).addPreferredGap(0, 73, Short.MAX_VALUE).add(this.bUpdate).addContainerGap()));
        pDownloadLayout.setVerticalGroup(pDownloadLayout.createParallelGroup(1).add(pDownloadLayout.createParallelGroup(3).add(this.tfComponentListURL, -2, -1, -2).add(this.bUpdate)));
        this.bInstall.setText("Install selected");
        this.bInstall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstallerGUI.this.bInstallActionPerformed(evt);
            }
        });
        this.bUninstall.setText("Uninstall selected");
        this.bUninstall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstallerGUI.this.bUninstallActionPerformed(evt);
            }
        });
        this.bUninstall1.setText("Quit");
        this.bUninstall1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstallerGUI.this.quitActionPerformed(evt);
            }
        });
        GroupLayout pInstallButtonsLayout = new GroupLayout(this.pInstallButtons);
        this.pInstallButtons.setLayout(pInstallButtonsLayout);
        pInstallButtonsLayout.setHorizontalGroup(pInstallButtonsLayout.createParallelGroup(1).add(2, pInstallButtonsLayout.createSequentialGroup().add(146, 146, 146).add(this.bInstall, -1, -1, Short.MAX_VALUE).add(14, 14, 14).add(this.bUninstall).addPreferredGap(0).add(this.bUninstall1).add(194, 194, 194)));
        pInstallButtonsLayout.setVerticalGroup(pInstallButtonsLayout.createParallelGroup(1).add(pInstallButtonsLayout.createSequentialGroup().addContainerGap().add(pInstallButtonsLayout.createParallelGroup(3).add(this.bUninstall).add(this.bInstall).add(this.bUninstall1)).addContainerGap(-1, Short.MAX_VALUE)));
        this.spLanguages.setHorizontalScrollBarPolicy(31);
        this.pLanguages.setLayout(new BoxLayout(this.pLanguages, 1));
        this.spLanguages.setViewportView(this.pLanguages);
        this.spVoices.setHorizontalScrollBarPolicy(31);
        this.pVoices.setLayout(new BoxLayout(this.pVoices, 1));
        this.spVoices.setViewportView(this.pVoices);
        this.jLabel1.setText("Languages");
        this.jLabel2.setText("Voices");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(1).add(this.spLanguages, -2, 340, -2).add(this.jLabel1)).add(21, 21, 21).add(jPanel1Layout.createParallelGroup(1).add(this.spVoices, -2, 369, -2).add(this.jLabel2)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(2, jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(3).add(this.jLabel1).add(this.jLabel2)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(1).add(this.spVoices, -1, 303, Short.MAX_VALUE).add(this.spLanguages, -1, 303, Short.MAX_VALUE))));
        this.menuTools1.setText("Tools");
        this.miProxy1.setText("Proxy settings...");
        this.miProxy1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstallerGUI.this.miProxy1ActionPerformed(evt);
            }
        });
        this.menuTools1.add(this.miProxy1);
        this.menuBar1.add(this.menuTools1);
        this.setJMenuBar(this.menuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2).add(1, this.jPanel1, 0, 730, Short.MAX_VALUE).add(1, this.pInstallButtons, -1, -1, Short.MAX_VALUE).add(1, this.pDownload, -2, -1, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.pDownload, -2, -1, -2).addPreferredGap(0).add(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add(this.pInstallButtons, -2, -1, -2)));
        this.pack();
    }

    private void tfComponentListURLActionPerformed(ActionEvent evt) {
        this.updateFromMaryComponentURL();
    }

    private void miProxy1ActionPerformed(ActionEvent evt) {
        ProxyPanel prp = new ProxyPanel(System.getProperty("http.proxyHost"), System.getProperty("http.proxyPort"));
        final JOptionPane optionPane = new JOptionPane(prp, -1, 0, null, new String[]{"OK", "Cancel"}, "OK");
        final JDialog dialog = new JDialog(null, "", true);
        dialog.setContentPane(optionPane);
        optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (dialog.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                    dialog.setVisible(false);
                }
            }
        });
        dialog.pack();
        dialog.setVisible(true);
        if ("OK".equals(optionPane.getValue())) {
            System.setProperty("http.proxyHost", prp.getProxyHost());
            System.setProperty("http.proxyPort", prp.getProxyPort());
        }
    }

    private void bUninstallActionPerformed(ActionEvent evt) {
        this.uninstallSelectedLanguagesAndVoices();
    }

    private void bInstallActionPerformed(ActionEvent evt) {
        this.installSelectedLanguagesAndVoices();
    }

    private void bUpdateActionPerformed(ActionEvent evt) {
        this.updateFromMaryComponentURL();
    }

    private void updateFromMaryComponentURL() throws HeadlessException {
        String urlString = this.tfComponentListURL.getText().trim().replaceAll(" ", "%20");
        try {
            URL url = new URL(urlString);
            InstallFileParser p = new InstallFileParser(url);
            this.addLanguagesAndVoices(p);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.close();
            String message = sw.toString();
            JOptionPane.showMessageDialog(this, "Problem retrieving component list:\n" + message);
        }
    }

    private void windowClosing(WindowEvent evt) {
        this.confirmExit();
    }

    private void quitActionPerformed(ActionEvent evt) {
        this.confirmExit();
    }

    private void customInitComponents() {
        this.bUpdate.requestFocusInWindow();
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                PasswordPanel passP = new PasswordPanel();
                final JOptionPane optionPane = new JOptionPane(passP, -1, -1, null, new String[]{"OK", "Cancel"}, "OK");
                final JDialog dialog = new JDialog(null, "", true);
                dialog.setContentPane(optionPane);
                optionPane.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        String prop = e.getPropertyName();
                        if (dialog.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                            dialog.setVisible(false);
                        }
                    }
                });
                dialog.pack();
                dialog.setVisible(true);
                if ("OK".equals(optionPane.getValue())) {
                    return new PasswordAuthentication(passP.getUser(), passP.getPassword());
                }
                return null;
            }
        });
    }

    private void updateLanguagesTable() {
        this.pLanguages.removeAll();
        for (String dName : this.languages.keySet()) {
            ComponentDescription desc = this.languages.get(dName);
            this.pLanguages.add(new ShortDescriptionPanel(desc, this));
        }
        this.pLanguages.add(Box.createVerticalGlue());
        if (this.languages.size() > 0) {
            this.pLanguages.getComponent(0).requestFocusInWindow();
            this.updateVoices(this.languages.get(this.languages.keySet().iterator().next()), true);
        }
    }

    @Override
    public void updateVoices(LanguageComponentDescription newLanguage, boolean forceUpdate) {
        if (this.currentLanguage != null && this.currentLanguage.equals(newLanguage) && !forceUpdate) {
            return;
        }
        this.currentLanguage = newLanguage;
        List<VoiceComponentDescription> lVoices = this.getVoicesForLanguage(this.currentLanguage);
        this.pVoices.removeAll();
        for (ComponentDescription componentDescription : lVoices) {
            this.pVoices.add(new ShortDescriptionPanel(componentDescription, null));
        }
        this.pVoices.add(Box.createVerticalGlue());
        this.pVoices.repaint();
        this.pack();
    }

    private HashSet<ComponentDescription> getAllInstalledComponents() {
        HashSet<ComponentDescription> components = new HashSet<ComponentDescription>();
        for (ComponentDescription componentDescription : this.languages.values()) {
            if (!componentDescription.getStatus().equals((Object)ComponentDescription.Status.INSTALLED)) continue;
            components.add(componentDescription);
        }
        for (ComponentDescription componentDescription : this.voices.values()) {
            if (!componentDescription.getStatus().equals((Object)ComponentDescription.Status.INSTALLED)) continue;
            components.add(componentDescription);
        }
        return components;
    }

    private List<VoiceComponentDescription> getVoicesForLanguage(LanguageComponentDescription language) {
        ArrayList<VoiceComponentDescription> lVoices = new ArrayList<VoiceComponentDescription>();
        for (String vName : this.voices.keySet()) {
            VoiceComponentDescription v = this.voices.get(vName);
            if (!v.getDependsLanguage().equals(language.getName())) continue;
            lVoices.add(v);
        }
        return lVoices;
    }

    private void confirmExit() {
        int choice;
        if (this.getComponentsSelectedForInstallation().size() + this.getComponentsSelectedForUninstall().size() == 0) {
            this.setVisible(false);
            System.exit(0);
        }
        if ((choice = JOptionPane.showConfirmDialog(this, "Discard selection and exit?", "Exit program", 0)) == 0) {
            this.setVisible(false);
            System.exit(0);
        }
    }

    private List<ComponentDescription> getComponentsSelectedForInstallation() {
        ArrayList<ComponentDescription> toInstall = new ArrayList<ComponentDescription>();
        for (String langName : this.languages.keySet()) {
            LanguageComponentDescription lang = this.languages.get(langName);
            if (lang.isSelected() && (lang.getStatus() != ComponentDescription.Status.INSTALLED || lang.isUpdateAvailable())) {
                toInstall.add(lang);
                System.out.println(String.valueOf(lang.getName()) + " selected for installation");
            }
            List<VoiceComponentDescription> lVoices = this.getVoicesForLanguage(lang);
            for (VoiceComponentDescription voice : lVoices) {
                if (!voice.isSelected() || voice.getStatus() == ComponentDescription.Status.INSTALLED && !voice.isUpdateAvailable()) continue;
                toInstall.add(voice);
                System.out.println(String.valueOf(voice.getName()) + " selected for installation");
            }
        }
        return toInstall;
    }

    public void installSelectedLanguagesAndVoices() {
        long downloadSize = 0L;
        List<ComponentDescription> toInstall = this.getComponentsSelectedForInstallation();
        if (toInstall.size() == 0) {
            JOptionPane.showMessageDialog(this, "You have not selected any installable components");
            return;
        }
        TreeMap<String, String> unmetDependencies = new TreeMap<String, String>();
        for (ComponentDescription cd : toInstall) {
            if (!(cd instanceof VoiceComponentDescription)) continue;
            VoiceComponentDescription vcd = (VoiceComponentDescription)cd;
            String depLang = vcd.getDependsLanguage();
            String depVersion = vcd.getDependsVersion();
            LanguageComponentDescription lcd = this.languages.get(depLang);
            if (lcd == null) {
                unmetDependencies.put(depLang, "-- no such language component");
                continue;
            }
            if (lcd.getStatus() == ComponentDescription.Status.INSTALLED) {
                if (!ComponentDescription.isVersionNewerThan(depVersion, lcd.getVersion())) continue;
                ComponentDescription update = lcd.getAvailableUpdate();
                if (update == null) {
                    unmetDependencies.put(depLang, "version " + depVersion + " is required by " + vcd.getName() + ",\nbut older version " + lcd.getVersion() + " is installed and no update is available");
                    continue;
                }
                if (ComponentDescription.isVersionNewerThan(depVersion, update.getVersion())) {
                    unmetDependencies.put(depLang, "version " + depVersion + " is required by " + vcd.getName() + ",\nbut only version " + update.getVersion() + " is available as an update");
                    continue;
                }
                if (toInstall.contains(lcd)) continue;
                unmetDependencies.put(depLang, "version " + depVersion + " is required by " + vcd.getName() + ",\nbut older version " + lcd.getVersion() + " is installed\nand update to version " + update.getVersion() + " is not selected for installation");
                continue;
            }
            if (toInstall.contains(lcd)) continue;
            if (ComponentDescription.isVersionNewerThan(depVersion, lcd.getVersion())) {
                unmetDependencies.put(depLang, "version " + depVersion + " is required by " + vcd.getName() + ",\nbut only older version " + lcd.getVersion() + " is available");
                continue;
            }
            unmetDependencies.put(depLang, "is required  by " + vcd.getName() + "\nbut is not selected for installation");
        }
        if (unmetDependencies.size() > 0) {
            StringBuilder buf = new StringBuilder();
            for (Object compName : unmetDependencies.keySet()) {
                buf.append("Component ").append((String)compName).append(" ").append((String)unmetDependencies.get(compName)).append("\n");
            }
            JOptionPane.showMessageDialog(this, buf.toString(), "Dependency problem", 2);
            return;
        }
        for (ComponentDescription cd : toInstall) {
            if (cd.getStatus() == ComponentDescription.Status.AVAILABLE) {
                downloadSize += (long)cd.getPackageSize();
                continue;
            }
            if (cd.getStatus() != ComponentDescription.Status.INSTALLED || !cd.isUpdateAvailable() || cd.getAvailableUpdate().getStatus() != ComponentDescription.Status.AVAILABLE) continue;
            downloadSize += (long)cd.getAvailableUpdate().getPackageSize();
        }
        int returnValue = JOptionPane.showConfirmDialog(this, "Install " + toInstall.size() + " components?\n(" + MaryUtils.toHumanReadableSize(downloadSize) + " to download)", "Proceed with installation?", 0);
        if (returnValue != 0) {
            System.err.println("Aborting installation.");
            return;
        }
        System.out.println("Check license(s)");
        boolean accepted = this.showLicenses(toInstall);
        if (accepted) {
            System.out.println("Starting installation");
            this.showProgressPanel(toInstall, true);
        }
    }

    private boolean showLicenses(List<ComponentDescription> toInstall) {
        HashMap<URL, TreeSet<ComponentDescription>> licenseGroups = new HashMap<URL, TreeSet<ComponentDescription>>();
        for (ComponentDescription cd : toInstall) {
            URL licenseURL = cd.getLicenseURL();
            TreeSet<ComponentDescription> compsUnderLicense = (TreeSet<ComponentDescription>)licenseGroups.get(licenseURL);
            if (compsUnderLicense == null) {
                compsUnderLicense = new TreeSet<ComponentDescription>();
                licenseGroups.put(licenseURL, compsUnderLicense);
            }
            assert (compsUnderLicense != null);
            compsUnderLicense.add(cd);
        }
        for (URL licenseURL : licenseGroups.keySet()) {
            if (licenseURL == null) continue;
            URL localURL = LicenseRegistry.getLicense(licenseURL);
            SortedSet comps = (SortedSet)licenseGroups.get(licenseURL);
            System.out.println("Showing license " + licenseURL + " for " + comps.size() + " components");
            LicensePanel licensePanel = new LicensePanel(localURL, comps);
            final JOptionPane optionPane = new JOptionPane(licensePanel, -1, 0, null, new String[]{"Reject", "Accept"}, "Reject");
            optionPane.setPreferredSize(new Dimension(800, 600));
            final JDialog dialog = new JDialog(null, "Do you accept the following license?", true);
            dialog.setContentPane(optionPane);
            optionPane.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    String prop = e.getPropertyName();
                    if (dialog.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                        dialog.setVisible(false);
                    }
                }
            });
            dialog.pack();
            dialog.setVisible(true);
            if (!"Accept".equals(optionPane.getValue())) {
                System.out.println("License not accepted. Installation of component cannot proceed.");
                return false;
            }
            System.out.println("License accepted.");
        }
        return true;
    }

    private List<ComponentDescription> getComponentsSelectedForUninstall() {
        ArrayList<ComponentDescription> toUninstall = new ArrayList<ComponentDescription>();
        for (String langName : this.languages.keySet()) {
            LanguageComponentDescription lang = this.languages.get(langName);
            if (lang.isSelected() && lang.getStatus() == ComponentDescription.Status.INSTALLED) {
                toUninstall.add(lang);
                System.out.println(String.valueOf(lang.getName()) + " selected for uninstall");
            }
            List<VoiceComponentDescription> lVoices = this.getVoicesForLanguage(lang);
            for (VoiceComponentDescription voice : lVoices) {
                if (!voice.isSelected() || voice.getStatus() != ComponentDescription.Status.INSTALLED) continue;
                toUninstall.add(voice);
                System.out.println(String.valueOf(voice.getName()) + " selected for uninstall");
            }
        }
        this.findAndStoreSharedFiles(toUninstall);
        return toUninstall;
    }

    private void findAndStoreSharedFiles(List<ComponentDescription> uninstallComponents) {
        HashSet<ComponentDescription> retainComponents = this.getAllInstalledComponents();
        retainComponents.removeAll(uninstallComponents);
        if (retainComponents.isEmpty()) {
            return;
        }
        TreeSet<String> retainFiles = new TreeSet<String>();
        for (ComponentDescription retainComponent : retainComponents) {
            retainFiles.addAll(retainComponent.getInstalledFileNames());
        }
        for (ComponentDescription uninstallComponent : uninstallComponents) {
            HashSet<String> sharedFiles = new HashSet<String>(uninstallComponent.getInstalledFileNames());
            sharedFiles.retainAll(retainFiles);
            if (sharedFiles.isEmpty()) continue;
            uninstallComponent.setSharedFiles(sharedFiles);
        }
    }

    public void uninstallSelectedLanguagesAndVoices() {
        List<ComponentDescription> toUninstall = this.getComponentsSelectedForUninstall();
        if (toUninstall.size() == 0) {
            JOptionPane.showMessageDialog(this, "You have not selected any uninstallable components");
            return;
        }
        int returnValue = JOptionPane.showConfirmDialog(this, "Uninstall " + toUninstall.size() + " components?\n", "Proceed with uninstall?", 0);
        if (returnValue != 0) {
            System.err.println("Aborting uninstall.");
            return;
        }
        System.out.println("Starting uninstall");
        this.showProgressPanel(toUninstall, false);
    }

    private void showProgressPanel(List<ComponentDescription> comps, boolean install) {
        final ProgressPanel pp = new ProgressPanel(comps, install);
        final JOptionPane optionPane = new JOptionPane(pp, -1, -1, null, new String[]{"Abort"}, "Abort");
        final JDialog dialog = new JDialog(null, "Progress", false);
        dialog.setContentPane(optionPane);
        optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (dialog.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                    pp.requestExit();
                    dialog.setVisible(false);
                }
            }
        });
        dialog.pack();
        dialog.setVisible(true);
        new Thread(pp).start();
    }

    public static void main(String[] args) throws Exception {
        File cd;
        File[] componentDescriptionFiles;
        String maryBase = System.getProperty("mary.base");
        if (maryBase == null || !new File(maryBase).isDirectory()) {
            File file;
            JFrame window = new JFrame("This is the Frames's Title Bar!");
            JFileChooser fc = new JFileChooser();
            fc.setDialogTitle("Please indicate MARY TTS installation directory");
            fc.setFileSelectionMode(1);
            int returnVal = fc.showOpenDialog(window);
            if (returnVal == 0 && (file = fc.getSelectedFile()) != null) {
                maryBase = file.getAbsolutePath();
            }
        }
        if (maryBase == null || !new File(maryBase).isDirectory()) {
            System.out.println("No MARY base directory -- exiting.");
            System.exit(0);
        }
        System.setProperty("mary.base", maryBase);
        File archiveDir = new File(String.valueOf(maryBase) + "/download");
        if (!archiveDir.exists()) {
            archiveDir.mkdir();
        }
        System.setProperty("mary.downloadDir", archiveDir.getPath());
        File infoDir = new File(String.valueOf(maryBase) + "/installed");
        if (!infoDir.exists()) {
            infoDir.mkdir();
        }
        System.setProperty("mary.installedDir", infoDir.getPath());
        InstallerGUI g = new InstallerGUI();
        File[] fileArray = componentDescriptionFiles = infoDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        });
        int n = componentDescriptionFiles.length;
        int n2 = 0;
        while (n2 < n) {
            cd = fileArray[n2];
            try {
                g.addLanguagesAndVoices(new InstallFileParser(cd.toURI().toURL()));
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            ++n2;
        }
        fileArray = componentDescriptionFiles = archiveDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        });
        n = componentDescriptionFiles.length;
        n2 = 0;
        while (n2 < n) {
            cd = fileArray[n2];
            try {
                g.addLanguagesAndVoices(new InstallFileParser(cd.toURI().toURL()));
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            ++n2;
        }
        if (args.length > 0) {
            g.setAndUpdateFromMaryComponentURL(args[0]);
        }
        g.setVisible(true);
    }
}

