/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.process.FrameOverlapAddSource;
import marytts.signalproc.process.VocalTractModifier;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class VocalTractScalingProcessor
extends VocalTractModifier {
    private double[] vscales;
    private double[] PxOut;

    public VocalTractScalingProcessor(int p, int fs, int fftSize, double[] vscalesIn) {
        super(p, fs, fftSize);
        this.PxOut = new double[this.maxFreq];
        if (vscalesIn.length > 0) {
            this.vscales = MathUtils.modifySize(vscalesIn, this.maxFreq);
            int i = 0;
            while (i < this.maxFreq) {
                if (this.vscales[i] < 0.05) {
                    this.vscales[i] = 0.05;
                }
                ++i;
            }
        } else {
            this.vscales = null;
        }
    }

    @Override
    protected void processSpectrum(double[] Px) {
        block5: {
            if (this.vscales == null) break block5;
            int newLen = (int)Math.floor((double)Px.length * this.vscales[0] + 0.5);
            double[] Px2 = MathUtils.interpolate(Px, newLen);
            if (newLen > this.maxFreq) {
                int i = 0;
                while (i < this.maxFreq) {
                    Px[i] = Px2[i];
                    ++i;
                }
            } else {
                int i = 0;
                while (i < newLen) {
                    Px[i] = Px2[i];
                    ++i;
                }
                i = newLen;
                while (i < this.maxFreq) {
                    Px[i] = 0.0;
                    ++i;
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        double[] vscales = new double[]{1.0};
        int i = 0;
        while (i < args.length) {
            AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[i]));
            int samplingRate = (int)inputAudio.getFormat().getSampleRate();
            int p = SignalProcUtils.getLPOrder(samplingRate);
            int fftSize = Math.max(SignalProcUtils.getDFTSize(samplingRate), 1024);
            AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
            FrameOverlapAddSource foas = new FrameOverlapAddSource(signal, 3, true, fftSize, samplingRate, new VocalTractScalingProcessor(p, samplingRate, fftSize, vscales));
            DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(foas), inputAudio.getFormat());
            String outFileName = String.valueOf(args[i].substring(0, args[i].length() - 4)) + "_vocalTractScaled.wav";
            AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
            ++i;
        }
    }
}

