/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.display.SignalGraph;
import marytts.signalproc.display.SignalSpectrum;
import marytts.signalproc.display.Spectrogram;
import marytts.signalproc.process.FrameOverlapAddSource;
import marytts.signalproc.process.PolarFrequencyProcessor;
import marytts.util.data.BaseDoubleDataSource;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.math.MathUtils;

public class PhaseVocoder
extends FrameOverlapAddSource {
    public static final int DEFAULT_FRAMELENGTH = 2048;
    protected double rateChangeFactor;

    public PhaseVocoder(DoubleDataSource inputSource, int samplingRate, double rateChangeFactor) {
        this.rateChangeFactor = rateChangeFactor;
        int frameLength = 2048;
        int s = samplingRate;
        while ((s *= 2) <= 44100) {
            frameLength /= 2;
        }
        this.initialise(inputSource, 3, true, frameLength, samplingRate, null);
    }

    @Override
    protected int getInputFrameshift(int outputFrameshift) {
        int inputFrameshift = (int)((double)outputFrameshift * this.rateChangeFactor);
        double actualFactor = (double)inputFrameshift / (double)outputFrameshift;
        if (this.rateChangeFactor != actualFactor) {
            System.err.println("With output frameshift " + outputFrameshift + ", need to adjust rate change factor to " + actualFactor);
            this.rateChangeFactor = actualFactor;
        }
        return inputFrameshift;
    }

    public int computeOutputLength(int inputLengthInSamples) {
        int f = this.frameProvider.getFrameLengthSamples();
        int so = this.blockSize;
        int si = this.frameProvider.getFrameShiftSamples();
        assert (si == this.getInputFrameshift(so));
        int n = (int)Math.ceil(((double)inputLengthInSamples - (double)f) / (double)si);
        int delta = f + n * si - inputLengthInSamples;
        assert (delta < si);
        int lo = f + n * so - delta;
        return lo;
    }

    public static void main(String[] args) throws Exception {
        int i = 1;
        while (i < args.length) {
            AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[i]));
            int samplingRate = (int)inputAudio.getFormat().getSampleRate();
            BaseDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
            double[] signalData = new AudioDoubleDataSource(inputAudio).getAllData();
            SignalGraph signalGraph = new SignalGraph(signalData, samplingRate);
            signalGraph.showInJFrame("signal", true, true);
            SignalSpectrum signalSpectrum = new SignalSpectrum(signalData, samplingRate);
            signalSpectrum.showInJFrame("signal", true, true);
            signal = new BufferedDoubleDataSource(signalData);
            PhaseVocoder pv = new PhaseVocoder(signal, samplingRate, Double.parseDouble(args[0]));
            double[] result = pv.getAllData();
            SignalGraph resultGraph = new SignalGraph(result, samplingRate);
            resultGraph.showInJFrame("result", true, true);
            Spectrogram resultSpectrogram = new Spectrogram(result, samplingRate);
            resultSpectrogram.showInJFrame("result", true, true);
            SignalSpectrum resultSpectrum = new SignalSpectrum(result, samplingRate);
            resultSpectrum.showInJFrame("result", true, true);
            System.err.println("Signal has length " + signalData.length + ", result " + result.length);
            if (signalData.length == result.length) {
                double err = MathUtils.sumSquaredError(signalData, result);
                System.err.println("Sum squared error: " + err);
                double[] difference = MathUtils.subtract(signalData, result);
                SignalGraph diffGraph = new SignalGraph(difference, samplingRate);
                diffGraph.showInJFrame("difference", true, true);
            }
            double meanSignalEnergy = MathUtils.mean(MathUtils.multiply(signalData, signalData));
            double meanResultEnergy = MathUtils.mean(MathUtils.multiply(result, result));
            System.err.println("Mean result energy: " + meanResultEnergy / meanSignalEnergy * 100.0 + "% of mean signal energy");
            DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(pv), inputAudio.getFormat());
            String outFileName = String.valueOf(args[i].substring(0, args[i].length() - 4)) + "_stretched_by_" + args[0] + ".wav";
            AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
            ++i;
        }
    }

    public class PhaseUnwrapper
    extends PolarFrequencyProcessor {
        protected double[] omega;
        protected double[] prevPhi;
        protected double[] deltaPhi;
        protected double[] psi;

        public PhaseUnwrapper(int fftSize) {
            super(fftSize);
            this.omega = new double[fftSize];
            int ifs = PhaseVocoder.this.getInputFrameshift(PhaseVocoder.this.blockSize);
            int i = 0;
            while (i < fftSize) {
                this.omega[i] = Math.PI * 2 * (double)ifs * (double)i / (double)fftSize;
                ++i;
            }
            this.prevPhi = new double[fftSize];
            this.deltaPhi = new double[fftSize];
            this.psi = new double[fftSize];
        }

        @Override
        protected void processPolar(double[] r, double[] phi) {
            assert (phi.length == this.prevPhi.length);
            int i = 0;
            while (i < phi.length) {
                this.deltaPhi[i] = this.omega[i] + MathUtils.angleToDefaultAngle(phi[i] - this.prevPhi[i] - this.omega[i]);
                if (i == 123) {
                    System.err.println("i=" + i + ": phi=" + phi[i] + " prevPhi=" + this.prevPhi[i] + " diff in defaultrange=" + MathUtils.angleToDefaultAngle(phi[i] - this.prevPhi[i] - this.omega[i]) + " omega=" + this.omega[i] + " deltaPhi=" + this.deltaPhi[i]);
                }
                ++i;
            }
            System.arraycopy(phi, 0, this.prevPhi, 0, phi.length);
            i = 0;
            while (i < phi.length) {
                this.psi[i] = MathUtils.angleToDefaultAngle(this.psi[i] + this.deltaPhi[i] / PhaseVocoder.this.rateChangeFactor);
                ++i;
            }
            System.arraycopy(this.psi, 0, phi, 0, phi.length);
        }
    }
}

