/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.display;

import java.awt.Color;
import java.io.File;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.analysis.EnergyAnalyser;
import marytts.signalproc.analysis.FrameBasedAnalyser;
import marytts.signalproc.display.Histogram;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;

public class SilenceMarker
extends Histogram {
    public SilenceMarker(AudioInputStream ais) {
        this(ais, 640, 480);
    }

    public SilenceMarker(AudioInputStream ais, int width, int height) {
        if (!ais.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            ais = AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, ais);
        }
        if (ais.getFormat().getChannels() > 1) {
            throw new IllegalArgumentException("Can only deal with mono audio signals");
        }
        int samplingRate = (int)ais.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(ais);
        this.initialise(signal, samplingRate, width, height);
    }

    public SilenceMarker(double[] signal, int samplingRate) {
        this(signal, samplingRate, 640, 480);
    }

    public SilenceMarker(double[] signal, int samplingRate, int width, int height) {
        this.initialise(new BufferedDoubleDataSource(signal), samplingRate, width, height);
    }

    protected void initialise(DoubleDataSource signal, int samplingRate, int width, int height) {
        this.showYAxis = false;
        this.showXAxis = false;
        this.paddingTop = 5;
        this.paddingBottom = 5;
        double frameDuration = 0.01;
        int frameLength = (int)((double)samplingRate * frameDuration);
        int frameShift = frameLength / 2;
        if (frameLength % 2 == 0) {
            ++frameLength;
        }
        EnergyAnalyser energyAnalyser = new EnergyAnalyser(signal, frameLength, frameShift, samplingRate);
        double silenceCutoff = energyAnalyser.getSilenceCutoff();
        FrameBasedAnalyser.FrameAnalysisResult<T>[] results = energyAnalyser.analyseAllFrames();
        double[] silenceData = new double[results.length];
        int i = 0;
        while (i < results.length) {
            double energy = (Double)results[i].get();
            silenceData[i] = energy <= silenceCutoff ? 0.0 : 1.0;
            ++i;
        }
        super.initialise(width, height, 0.0, (double)frameShift / (double)samplingRate, silenceData);
        this.histogramBorderColor = Color.LIGHT_GRAY;
        this.setPrimaryDataSeriesStyle(this.histogramBorderColor, 4, -1);
    }

    public static void main(String[] args) throws Exception {
        int i = 0;
        while (i < args.length) {
            AudioInputStream ais = AudioSystem.getAudioInputStream(new File(args[i]));
            SilenceMarker signalGraph = new SilenceMarker(ais);
            signalGraph.showInJFrame(args[i], true, false);
            ++i;
        }
    }
}

