/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.IOException;
import marytts.signalproc.analysis.PitchFileHeader;
import marytts.signalproc.analysis.PitchReaderWriter;
import marytts.util.string.StringUtils;

public class F0ReaderWriter
extends PitchReaderWriter {
    public static final int DEFAULT_SAMPLING_RATE = 16000;
    public static final double DEFAULT_WINDOW_SIZE_IN_SECONDS = 0.0075;
    public static final double DEFAULT_SKIP_SIZE_IN_SECONDS = 0.01;

    public F0ReaderWriter(String f0File) {
        this(f0File, 16000, 0.0075, 0.01);
    }

    public F0ReaderWriter(String f0File, int samplingRate, double windowSizeInSeconds, double skipSizeInSeconds) {
        this.contour = null;
        this.header = new PitchFileHeader();
        this.header.windowSizeInSeconds = 0.0;
        this.header.skipSizeInSeconds = 0.0;
        this.header.fs = 0;
        try {
            this.read_f0_file(f0File);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public F0ReaderWriter() {
        this.contour = null;
        this.header = new PitchFileHeader();
        this.header.windowSizeInSeconds = 0.0;
        this.header.skipSizeInSeconds = 0.0;
        this.header.fs = 0;
    }

    public void read_f0_file(String f0File) throws IOException {
        this.read_f0_file(f0File, 16000, 0.0075, 0.01);
    }

    public void read_f0_file(String f0File, int samplingRate, double windowSizeInSeconds, double skipSizeInSeconds) throws IOException {
        String[] lines = StringUtils.readTextFile(f0File, "ASCII");
        if (lines != null && lines[0] != null) {
            this.contour = new double[lines.length];
            int i = 0;
            while (i < lines.length) {
                int endIndex = lines[i].indexOf(" ");
                this.contour[i] = Double.valueOf(lines[i].substring(0, endIndex));
                ++i;
            }
            this.header.fs = samplingRate;
            this.header.numfrm = this.contour.length;
            this.header.windowSizeInSeconds = windowSizeInSeconds;
            this.header.skipSizeInSeconds = skipSizeInSeconds;
        }
    }
}

