/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import marytts.signalproc.analysis.EnergyAnalyser;
import marytts.util.data.DoubleDataSource;
import marytts.util.math.MathUtils;

public class EnergyAnalyser_dB
extends EnergyAnalyser {
    public EnergyAnalyser_dB(DoubleDataSource signal, int framelength, int samplingRate) {
        super(signal, framelength, samplingRate);
    }

    public EnergyAnalyser_dB(DoubleDataSource signal, int framelength, int frameShift, int samplingRate) {
        super(signal, framelength, frameShift, samplingRate);
    }

    public EnergyAnalyser_dB(DoubleDataSource signal, int framelength, int frameShift, int samplingRate, int maxSize) {
        super(signal, framelength, frameShift, samplingRate, maxSize);
    }

    @Override
    public Double analyse(double[] frame) {
        if (frame.length != this.getFrameLengthSamples()) {
            throw new IllegalArgumentException("Expected frame of length " + this.getFrameLengthSamples() + ", got " + frame.length);
        }
        double totalEnergy = 0.0;
        int i = 0;
        while (i < frame.length) {
            if (frame[i] != 0.0) {
                totalEnergy += MathUtils.db(frame[i] * frame[i]);
            }
            ++i;
        }
        this.rememberFrameEnergy(totalEnergy);
        return new Double(totalEnergy);
    }
}

