/*
 * Decompiled with CFR 0.152.
 */
package marytts.server.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.sound.sampled.AudioFileFormat;
import marytts.util.ConversionUtils;
import marytts.util.MaryUtils;
import marytts.util.data.audio.MaryAudioUtils;
import marytts.util.string.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.nio.entity.NByteArrayEntity;
import org.apache.http.nio.entity.NFileEntity;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.log4j.Logger;

public class MaryHttpServerUtils {
    private static Logger logger = MaryUtils.getLogger("http");

    public static void toHttpResponse(double[] x, HttpResponse response, String contentType) throws IOException {
        MaryHttpServerUtils.toHttpResponse(ConversionUtils.toByteArray(x), response, contentType);
    }

    public static void toHttpResponse(int[] x, HttpResponse response, String contentType) throws IOException {
        MaryHttpServerUtils.toHttpResponse(ConversionUtils.toByteArray(x), response, contentType);
    }

    public static void toHttpResponse(String x, HttpResponse response, String contentType) throws IOException {
        MaryHttpServerUtils.toHttpResponse(ConversionUtils.toByteArray(x), response, contentType);
    }

    public static void toHttpResponse(byte[] byteArray, HttpResponse response, String contentType) throws IOException {
        NByteArrayEntity body = new NByteArrayEntity(byteArray);
        body.setContentType(contentType);
        response.setEntity(body);
        response.setStatusCode(200);
    }

    public static void toHttpResponse(InputStream stream, HttpResponse response, String contentType) throws IOException {
        MaryHttpServerUtils.toHttpResponse(stream, response, contentType, -1L);
    }

    public static void toHttpResponse(InputStream stream, HttpResponse response, String contentType, long streamLength) throws IOException {
        InputStreamEntity body = new InputStreamEntity(stream, streamLength);
        body.setContentType(contentType);
        response.setEntity(body);
        response.setStatusCode(200);
    }

    public static void fileToHttpResponse(String fullPathFile, HttpResponse response, String contentType, boolean useFileChannels) {
        int status;
        File file = new File(fullPathFile);
        if (!file.exists()) {
            status = 404;
        } else if (!file.canRead() || file.isDirectory()) {
            status = 403;
        } else {
            status = 200;
            NFileEntity entity = new NFileEntity(file, contentType, useFileChannels);
            response.setEntity(entity);
        }
        response.setStatusCode(status);
    }

    public static Map<String, String> toKeyValuePairs(String httpString, boolean performUrlDecode) {
        if (httpString == null || httpString.length() == 0) {
            return null;
        }
        HashMap<String, String> keyValuePairs = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(httpString);
        String newToken = null;
        while (st.hasMoreTokens() && (newToken = st.nextToken("&")) != null) {
            int equalSignInd = newToken.indexOf("=");
            String param = newToken;
            String val = "";
            if (equalSignInd > -1) {
                param = newToken.substring(0, equalSignInd);
                val = newToken.substring(equalSignInd + 1);
            }
            if (performUrlDecode) {
                param = StringUtils.urlDecode(param);
                val = StringUtils.urlDecode(val);
            }
            keyValuePairs.put(param, val);
        }
        return keyValuePairs;
    }

    public static String getMimeType(AudioFileFormat.Type audioType) {
        if (audioType == AudioFileFormat.Type.WAVE) {
            return "audio/x-wav";
        }
        if (audioType == AudioFileFormat.Type.AU) {
            return "audio/basic";
        }
        if (audioType == AudioFileFormat.Type.AIFF || audioType == AudioFileFormat.Type.AIFC) {
            return "audio/x-aiff";
        }
        if (audioType.equals(MaryAudioUtils.getAudioFileFormatType("MP3"))) {
            return "audio/x-mpeg";
        }
        return "audio/basic";
    }

    public static void errorFileNotFound(HttpResponse response, String uri) {
        int status = 404;
        response.setStatusCode(status);
        String message = "File " + uri + " not found";
        logger.debug("Returning HTTP status " + status + ": " + message);
        try {
            NStringEntity entity = new NStringEntity("<html><body><h1>File not found</h1><p>" + message + "</p></body></html>", "UTF-8");
            entity.setContentType("text/html; charset=UTF-8");
            response.setEntity(entity);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    public static void errorInternalServerError(HttpResponse response, String message, Throwable exception) {
        int status = 500;
        response.setStatusCode(status);
        StringWriter sw = new StringWriter();
        exception.printStackTrace(new PrintWriter((Writer)sw, true));
        String logMessage = String.valueOf(message != null ? String.valueOf(message) + "\n" : "") + sw.toString();
        logger.debug("Returning HTTP status " + status + ": " + logMessage);
        try {
            NStringEntity entity = new NStringEntity("<html><body><h1>Internal server error</h1><p>" + (message != null ? message : "") + "<pre>" + sw.toString() + "</pre></body></html>", "UTF-8");
            entity.setContentType("text/html; charset=UTF-8");
            response.setEntity(entity);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    public static void errorMissingQueryParameter(HttpResponse response, String param) {
        int status = 400;
        response.setStatusCode(status);
        String message = "Request must contain the parameter " + param;
        logger.debug("Returning HTTP status " + status + ": " + message);
        try {
            NStringEntity entity = new NStringEntity("<html><body><h1>Bad request</h1><p>" + message + ".</h1></body></html>", "UTF-8");
            entity.setContentType("text/html; charset=UTF-8");
            response.setEntity(entity);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    public static void errorWrongQueryParameterValue(HttpResponse response, String paramName, String illegalValue, String explanation) {
        int status = 400;
        response.setStatusCode(status);
        String message = "The value '" + illegalValue + "' of parameter '" + paramName + "' is not valid" + (explanation != null ? ": " + explanation : "");
        logger.debug("Returning HTTP status " + status + ": " + message);
        try {
            NStringEntity entity = new NStringEntity("<html><body><h1>Bad request</h1><p>" + message + ".</h1></body></html>", "UTF-8");
            entity.setContentType("text/html; charset=UTF-8");
            response.setEntity(entity);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }
}

