/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.datatypes.MaryXML;
import marytts.modules.InternalModule;
import marytts.server.MaryProperties;
import marytts.util.MaryUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class TextToMaryXML
extends InternalModule {
    private DocumentBuilderFactory factory = null;
    private DocumentBuilder docBuilder = null;
    private boolean splitIntoParagraphs = MaryProperties.getBoolean("texttomaryxml.splitintoparagraphs");

    public TextToMaryXML() {
        super("TextToMaryXML", MaryDataType.TEXT, MaryDataType.RAWMARYXML, null);
    }

    @Override
    public void startup() throws Exception {
        if (this.factory == null) {
            this.factory = DocumentBuilderFactory.newInstance();
            this.factory.setNamespaceAware(true);
        }
        if (this.docBuilder == null) {
            this.docBuilder = this.factory.newDocumentBuilder();
        }
        super.startup();
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        String plainText = MaryUtils.normaliseUnicodePunctuation(d.getPlainText());
        MaryData result = new MaryData(this.outputType(), d.getLocale(), true);
        Document doc = result.getDocument();
        Element root = doc.getDocumentElement();
        Locale l = this.determineLocale(plainText, d.getLocale());
        root.setAttribute("xml:lang", MaryUtils.locale2xmllang(l));
        if (this.splitIntoParagraphs) {
            String[] inputTexts = plainText.split("\\n(\\s*\\n)+");
            int i = 0;
            while (i < inputTexts.length) {
                String paragraph = inputTexts[i].trim();
                if (paragraph.length() != 0) {
                    this.appendParagraph(paragraph, root, d.getLocale());
                }
                ++i;
            }
        } else {
            this.appendParagraph(plainText, root, d.getLocale());
        }
        result.setDocument(doc);
        return result;
    }

    private void appendParagraph(String text, Element root, Locale defaultLocale) {
        Element insertHere = root;
        String rootLanguage = root.getAttribute("xml:lang");
        String textLanguage = MaryUtils.locale2xmllang(this.determineLocale(text, defaultLocale));
        if (!textLanguage.equals(rootLanguage)) {
            Element voiceElement = MaryXML.appendChildElement(root, "voice");
            voiceElement.setAttribute("xml:lang", textLanguage);
            insertHere = voiceElement;
        }
        insertHere = MaryXML.appendChildElement(insertHere, "p");
        insertHere.appendChild(root.getOwnerDocument().createTextNode(text));
        Text textNode = (Text)insertHere.getFirstChild();
        String textNodeString = textNode.getData();
        this.logger.debug("textNodeString=`" + textNodeString + "'");
    }

    protected Locale determineLocale(String text, Locale defaultLocale) {
        if (defaultLocale == null) {
            defaultLocale = Locale.getDefault();
            this.logger.warn("Locale is null, overriding with " + defaultLocale);
        }
        return defaultLocale;
    }
}

