/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.StringReader;
import java.util.Locale;
import java.util.Scanner;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureProcessorManager;
import marytts.features.FeatureRegistry;
import marytts.features.TargetFeatureComputer;
import marytts.machinelearning.SoP;
import marytts.modules.InternalModule;
import marytts.modules.phonemiser.Allophone;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.modules.synthesis.Voice;
import marytts.server.MaryProperties;
import marytts.unitselection.UnitSelectionVoice;
import marytts.unitselection.select.Target;
import marytts.util.MaryRuntimeUtils;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryDomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public class SoPF0Modeller
extends InternalModule {
    protected SoP leftSop;
    protected SoP midSop;
    protected SoP rightSop;
    private String sopFileName;
    protected TargetFeatureComputer featureComputer;
    private FeatureProcessorManager featureProcessorManager;
    private AllophoneSet allophoneSet;
    private FeatureDefinition voiceFeatDef;
    private boolean logF0 = false;

    public SoPF0Modeller(String locale, String sopFile) throws Exception {
        this(MaryUtils.string2locale(locale), sopFile, FeatureRegistry.getFeatureProcessorManager(MaryUtils.string2locale(locale)));
    }

    public SoPF0Modeller(String locale, String sopFile, String featprocClassInfo) throws Exception {
        this(MaryUtils.string2locale(locale), sopFile, (FeatureProcessorManager)MaryRuntimeUtils.instantiateObject(featprocClassInfo));
    }

    protected SoPF0Modeller(Locale locale, String sopFile, FeatureProcessorManager featureProcessorManager) {
        super("SoPF0Modeller", MaryDataType.DURATIONS, MaryDataType.ACOUSTPARAMS, locale);
        this.sopFileName = sopFile;
        this.featureProcessorManager = featureProcessorManager;
    }

    @Override
    public void startup() throws Exception {
        super.startup();
        String sopFile = MaryProperties.getFilename(this.sopFileName);
        String strContext = "";
        try (Scanner s = null;){
            String nextLine;
            s = new Scanner(new BufferedReader(new FileReader(sopFile)));
            while (s.hasNext()) {
                nextLine = s.nextLine();
                if (nextLine.trim().equals("")) break;
                strContext = String.valueOf(strContext) + nextLine + "\n";
            }
            this.voiceFeatDef = new FeatureDefinition(new BufferedReader(new StringReader(strContext)), false);
            if (s.hasNext()) {
                nextLine = s.nextLine();
                this.leftSop = new SoP(nextLine, this.voiceFeatDef);
            }
            if (s.hasNext()) {
                nextLine = s.nextLine();
                this.midSop = new SoP(nextLine, this.voiceFeatDef);
            }
            if (s.hasNext()) {
                nextLine = s.nextLine();
                this.rightSop = new SoP(nextLine, this.voiceFeatDef);
            }
        }
        this.featureComputer = FeatureRegistry.getTargetFeatureComputer(this.featureProcessorManager, this.voiceFeatDef.getFeatureNames());
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        Document doc = d.getDocument();
        NodeIterator sentenceIt = MaryDomUtils.createNodeIterator((Node)doc, "s");
        Element sentence = null;
        while ((sentence = (Element)sentenceIt.nextNode()) != null) {
            Element syllable;
            Element voice = (Element)MaryDomUtils.getAncestor((Node)sentence, "voice");
            Voice maryVoice = Voice.getVoice(voice);
            if (maryVoice == null) {
                maryVoice = d.getDefaultVoice();
            }
            if (maryVoice == null) {
                Locale locale = MaryUtils.string2locale(doc.getDocumentElement().getAttribute("xml:lang"));
                maryVoice = Voice.getDefaultVoice(locale);
            }
            SoP currentLeftSop = this.leftSop;
            SoP currentMidSop = this.midSop;
            SoP currentRightSop = this.rightSop;
            TargetFeatureComputer currentFeatureComputer = this.featureComputer;
            if (maryVoice instanceof UnitSelectionVoice && this.voiceFeatDef != null) {
                currentFeatureComputer = new TargetFeatureComputer(this.featureProcessorManager, this.voiceFeatDef.getFeatureNames());
                this.logger.debug("Using voice feature definition");
            }
            if (currentLeftSop == null) {
                throw new NullPointerException("Do not have f0 prediction Sop model");
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker(sentence, "syllable");
            while ((syllable = (Element)tw.nextNode()) != null) {
                float right;
                float mid;
                float left;
                Element firstVoiced = null;
                Element vowel = null;
                Element lastVoiced = null;
                Element s = MaryDomUtils.getFirstChildElement(syllable);
                while (s != null) {
                    assert (s.getTagName().equals("ph")) : "expected phone element, found " + s.getTagName();
                    String phone = s.getAttribute("p");
                    if (this.allophoneSet == null) {
                        this.allophoneSet = MaryRuntimeUtils.determineAllophoneSet(s);
                    }
                    assert (this.allophoneSet != null);
                    Allophone allophone = this.allophoneSet.getAllophone(phone);
                    if (allophone.isVowel()) {
                        if (firstVoiced == null) {
                            firstVoiced = s;
                        }
                        if (vowel == null) {
                            vowel = s;
                        }
                        lastVoiced = s;
                    } else if (allophone.isVoiced()) {
                        if (firstVoiced == null) {
                            firstVoiced = s;
                        }
                        lastVoiced = s;
                    }
                    s = MaryDomUtils.getNextSiblingElement(s);
                }
                if (vowel == null) continue;
                assert (firstVoiced != null) : "First voiced should not be null";
                assert (lastVoiced != null) : "Last voiced should not be null";
                String phone = vowel.getAttribute("p");
                System.out.print("PHONE: " + phone + "  ");
                Target t = new Target(phone, vowel);
                t.setFeatureVector(currentFeatureComputer.computeFeatureVector(t));
                float leftF0InHz = left = (float)currentLeftSop.solve(t, this.voiceFeatDef, this.logF0, false);
                float midF0InHz = mid = (float)currentMidSop.solve(t, this.voiceFeatDef, this.logF0, false);
                float rightF0InHz = right = (float)currentRightSop.solve(t, this.voiceFeatDef, this.logF0, false);
                System.out.format("leftf0=%.3f midf0=%.3f  rightf0=%.3f \n", Float.valueOf(left), Float.valueOf(mid), Float.valueOf(right));
                String leftTargetString = "(0," + (int)leftF0InHz + ")";
                String currentVal = firstVoiced.getAttribute("f0");
                String newVal = !currentVal.equals("") ? String.valueOf(currentVal) + " " + leftTargetString : leftTargetString;
                firstVoiced.setAttribute("f0", newVal);
                String midTargetString = "(50," + (int)midF0InHz + ")";
                currentVal = vowel.getAttribute("f0");
                newVal = !currentVal.equals("") ? String.valueOf(currentVal) + " " + midTargetString : midTargetString;
                vowel.setAttribute("f0", newVal);
                String rightTargetString = "(100," + (int)rightF0InHz + ")";
                currentVal = lastVoiced.getAttribute("f0");
                newVal = !currentVal.equals("") ? String.valueOf(currentVal) + " " + rightTargetString : rightTargetString;
                lastVoiced.setAttribute("f0", newVal);
            }
        }
        MaryData output = new MaryData(this.outputType(), d.getLocale());
        output.setDocument(doc);
        return output;
    }
}

