/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.datatypes.MaryXML;
import marytts.exceptions.MaryConfigurationException;
import marytts.exceptions.NoSuchPropertyException;
import marytts.modules.InternalModule;
import marytts.server.MaryProperties;
import marytts.util.dom.DomUtils;
import marytts.util.dom.MaryDomUtils;
import marytts.util.dom.NameNodeFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.SAXException;

public class ProsodyGeneric
extends InternalModule {
    protected String paragraphDeclination;
    protected boolean applyParagraphDeclination;
    protected String syllableAccents;
    protected boolean accentedSyllables;
    protected String accentPriorities;
    protected Properties priorities;
    protected String tobiPredFilename;
    protected HashMap<String, Element> tobiPredMap = new HashMap();
    protected HashMap<String, Object> listMap = new HashMap();
    private boolean convertToBI2Contour;
    protected HashMap<String, String> toBI2ContourMap;
    protected static final Pattern nextPlusXTextPattern = Pattern.compile("nextPlus[0-9]+Text");
    protected static final Pattern previousMinusXTextPattern = Pattern.compile("previousMinus[0-9]+Text");
    protected static final Pattern nextPlusXAttributesPattern = Pattern.compile("nextPlus[0-9]+Attributes");
    protected static final Pattern previousMinusXAttributesPattern = Pattern.compile("previousMinus[0-9]+Attributes");

    public ProsodyGeneric() {
        this((Locale)null);
    }

    public ProsodyGeneric(MaryDataType inputType, MaryDataType outputType, Locale locale, String tobipredFileName, String accentPriorities, String syllableAccents, String paragraphDeclination) {
        super("Prosody", inputType, outputType, locale);
        this.tobiPredFilename = tobipredFileName;
        this.accentPriorities = accentPriorities;
        this.syllableAccents = syllableAccents;
        this.paragraphDeclination = paragraphDeclination;
    }

    public ProsodyGeneric(String locale, String propertyPrefix) {
        this(new Locale(locale), propertyPrefix);
    }

    public ProsodyGeneric(Locale locale, String propertyPrefix) {
        super("Prosody", MaryDataType.PHONEMES, MaryDataType.INTONATION, locale);
        this.tobiPredFilename = String.valueOf(propertyPrefix) + "tobipredparams";
        this.accentPriorities = String.valueOf(propertyPrefix) + "accentPriorities";
        this.syllableAccents = String.valueOf(propertyPrefix) + "syllableaccents";
        this.paragraphDeclination = String.valueOf(propertyPrefix) + "paragraphdeclination";
    }

    public ProsodyGeneric(String locale) {
        this(new Locale(locale), "fallback.prosody.");
    }

    public ProsodyGeneric(Locale locale) {
        this(locale, "fallback.prosody.");
    }

    @Override
    public void startup() throws Exception {
        this.priorities = new Properties();
        if (this.accentPriorities != null) {
            try (InputStream accentStream = MaryProperties.needStream(this.accentPriorities);){
                try {
                    this.priorities.load(accentStream);
                }
                catch (IOException e) {
                    throw new MaryConfigurationException("can't load accent priorities from " + MaryProperties.getProperty(this.accentPriorities), e);
                }
            }
        }
        this.accentedSyllables = this.syllableAccents != null ? MaryProperties.getBoolean(this.syllableAccents) : false;
        this.applyParagraphDeclination = this.paragraphDeclination != null ? MaryProperties.getBoolean(this.paragraphDeclination) : false;
        try {
            this.loadTobiPredRules();
            this.buildListMap();
        }
        catch (Exception e) {
            throw new MaryConfigurationException("Can't fill prosody maps ", e);
        }
        this.convertToBI2Contour = MaryProperties.getBoolean("prosody.convertToBI2Contour", false);
        if (this.convertToBI2Contour) {
            boolean externalToBI2Contour = MaryProperties.getBoolean("prosody.externalToBI2Contour", false);
            if (externalToBI2Contour) {
                String externalFileName = MaryProperties.getFilename("prosody.ToBI2ContourMapFile");
                try {
                    this.toBI2ContourMap = this.getToBI2ContourMap(externalFileName);
                }
                catch (IOException e) {
                    throw new MaryConfigurationException("can't read ToBI2Contour lookup file: " + externalFileName, e);
                }
            } else {
                this.toBI2ContourMap = this.getToBI2ContourMap();
            }
        }
        super.startup();
    }

    protected synchronized void loadTobiPredRules() throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException, NoSuchPropertyException, MaryConfigurationException {
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        f.setValidating(false);
        DocumentBuilder b = f.newDocumentBuilder();
        Document tobiPredRules = null;
        try (InputStream tobiruleStream = MaryProperties.needStream(this.tobiPredFilename);){
            tobiPredRules = b.parse(tobiruleStream);
        }
        Element root = tobiPredRules.getDocumentElement();
        Element e = MaryDomUtils.getFirstChildElement(root);
        while (e != null) {
            if (e.getTagName().equals("definitions")) {
                this.tobiPredMap.put("definitions", e);
            }
            if (e.getTagName().equals("accentposition")) {
                this.tobiPredMap.put("accentposition", e);
            }
            if (e.getTagName().equals("accentshape")) {
                this.tobiPredMap.put("accentshape", e);
            }
            if (e.getTagName().equals("boundaries")) {
                this.tobiPredMap.put("boundaries", e);
            }
            e = MaryDomUtils.getNextSiblingElement(e);
        }
    }

    protected synchronized void buildListMap() throws IOException {
        Element listDefinitions = null;
        listDefinitions = this.tobiPredMap.get("definitions");
        TreeWalker tw = ((DocumentTraversal)((Object)listDefinitions.getOwnerDocument())).createTreeWalker(listDefinitions, 1, new NameNodeFilter("list"), false);
        Element list = null;
        while ((list = (Element)tw.nextNode()) != null) {
            String name = list.getAttribute("name");
            if (list.hasAttribute("items")) {
                String items = list.getAttribute("items");
                HashSet<String> itemSet = new HashSet<String>();
                StringTokenizer st = items.contains(" ") ? new StringTokenizer(items, " ") : new StringTokenizer(items, ":");
                while (st.hasMoreTokens()) {
                    itemSet.add(st.nextToken());
                }
                this.listMap.put(name, itemSet);
            }
            if (!list.hasAttribute("file")) continue;
            String fileName = list.getAttribute("file");
            this.listMap.put(name, this.readListFromResource(fileName));
        }
    }

    protected Object readListFromResource(String resourceName) throws IOException {
        String suffix = resourceName.substring(resourceName.length() - 4, resourceName.length());
        if (suffix.equals(".txt")) {
            InputStream resourceStream = this.getClass().getResourceAsStream("prosody/" + resourceName);
            HashSet<String> listSet = new HashSet<String>();
            BufferedReader in = new BufferedReader(new InputStreamReader(resourceStream, "UTF-8"));
            while (in.ready()) {
                String line = in.readLine();
                listSet.add(line);
            }
            in.close();
            return listSet;
        }
        throw new IllegalArgumentException("Unknown list file format: " + suffix);
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        Document doc = d.getDocument();
        NodeIterator sentenceIt = ((DocumentTraversal)((Object)doc)).createNodeIterator(doc.getDocumentElement(), 1, new NameNodeFilter("s"), false);
        Element sentence = null;
        while ((sentence = (Element)sentenceIt.nextNode()) != null) {
            this.logger.debug("Processing next sentence");
            this.processSentence(sentence);
        }
        if (this.accentedSyllables) {
            this.copyAccentsToSyllables(doc);
        }
        if (this.applyParagraphDeclination) {
            NodeList paragraphs = doc.getElementsByTagName("p");
            int i = 0;
            while (i < paragraphs.getLength()) {
                Element paragraph = (Element)paragraphs.item(i);
                NodeList phrases = paragraph.getElementsByTagName("phrase");
                int steps = phrases.getLength();
                if (steps > 1) {
                    int j = 0;
                    while (j < steps) {
                        int pitchDiff = 10;
                        int rangeDiff = 40;
                        double factor = 0.5 - (double)((float)j / ((float)steps - 1.0f));
                        int pitchValue = (int)((double)pitchDiff * factor);
                        String pitchString = String.valueOf(pitchValue >= 0 ? "+" : "") + pitchValue + "%";
                        int rangeValue = (int)((double)rangeDiff * factor);
                        String rangeString = String.valueOf(rangeValue >= 0 ? "+" : "") + rangeValue + "%";
                        Element phrase = (Element)phrases.item(j);
                        Element prosody = MaryXML.createElement(phrase.getOwnerDocument(), "prosody");
                        phrase.getParentNode().insertBefore(prosody, phrase);
                        prosody.appendChild(phrase);
                        prosody.setAttribute("pitch", pitchString);
                        prosody.setAttribute("range", rangeString);
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (this.convertToBI2Contour) {
            this.convertTOBIAccents2ProsodyContour(doc);
        }
        MaryData result = new MaryData(this.outputType(), d.getLocale());
        result.setDocument(doc);
        return result;
    }

    private void convertTOBIAccents2ProsodyContour(Document doc) throws Exception {
        TreeWalker tw = MaryDomUtils.createTreeWalker((Node)doc, "t");
        Element tokenElement = (Element)tw.nextNode();
        while (tokenElement != null) {
            boolean hasAccentAttribute = tokenElement.hasAttribute("accent");
            if (hasAccentAttribute) {
                String accentAttribute = tokenElement.getAttribute("accent");
                boolean isDefined = this.toBI2ContourMap.containsKey(accentAttribute);
                if (!isDefined) {
                    tokenElement = (Element)tw.nextNode();
                    continue;
                }
                String contourValue = this.toBI2ContourMap.get(accentAttribute);
                assert (contourValue != null) : "contour attribute should not be null";
                Node tokenAncestor = tokenElement.getParentNode();
                Element prosody = MaryXML.createElement(doc, "prosody");
                prosody.setAttribute("contour", contourValue);
                prosody.appendChild(tokenElement.cloneNode(true));
                tokenAncestor.insertBefore(prosody, tokenElement);
                Element nextTokenElement = (Element)tw.nextNode();
                if (nextTokenElement == null) {
                    tokenAncestor.removeChild(tokenElement);
                    break;
                }
                tokenAncestor.removeChild(tokenElement);
                tokenElement = nextTokenElement;
                continue;
            }
            tokenElement = (Element)tw.nextNode();
        }
    }

    @Deprecated
    private boolean isDefinedAccent(String accentAttribute) {
        if ("H*".equals(accentAttribute)) {
            return true;
        }
        if ("L*".equals(accentAttribute)) {
            return true;
        }
        if ("L*+H".equals(accentAttribute)) {
            return true;
        }
        if ("L*+!H".equals(accentAttribute)) {
            return true;
        }
        if ("L+H*".equals(accentAttribute)) {
            return true;
        }
        return "!H*".equals(accentAttribute);
    }

    @Deprecated
    private String getAccentContour(String accentAttribute) {
        if ("H*".equals(accentAttribute)) {
            return "(4%, +10%)(18%,+20%)(34%,+26%)(50%,+30%)(66%,+26%)(82%,+20%)(96%,+10%)";
        }
        if ("L*".equals(accentAttribute)) {
            return "(4%, -10%)(18%,-20%)(34%,-26%)(50%,-30%)(66%,-26%)(82%,-20%)(96%,-10%)";
        }
        if ("L*+H".equals(accentAttribute)) {
            return "(2%, -7%)(18%,-16%)(34%,-19%)(50%,-20%)(66%,-15%)(82%,-4%)(100%,+25%)";
        }
        if ("L*+!H".equals(accentAttribute)) {
            return "(0%, +5%)(4%, -7%)(18%,-16%)(34%,-20%)(48%, -7%)(52%, +10%)(66%,+20%)(82%,+26%)(100%,+30%)";
        }
        if ("L+H*".equals(accentAttribute)) {
            return "(0%, -20%)(18%,-19%)(34%,-17%)(45%, -7%)(55%, +10%)(66%,+25%)(82%,+28%)(100%,+30%)";
        }
        if ("!H*".equals(accentAttribute)) {
            return "(0%, +30%)(18%,+10%)(34%,+5%)(50%,0%)(66%,-13%)(82%,-17%)(100%,-20%)";
        }
        return null;
    }

    private HashMap<String, String> getToBI2ContourMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("H*", "(4%, +10%)(18%,+20%)(34%,+26%)(50%,+30%)(66%,+26%)(82%,+20%)(96%,+10%)");
        map.put("L*", "(4%, -10%)(18%,-20%)(34%,-26%)(50%,-30%)(66%,-26%)(82%,-20%)(96%,-10%)");
        map.put("L*+H", "(2%, -7%)(18%,-16%)(34%,-19%)(50%,-20%)(66%,-15%)(82%,-4%)(100%,+25%)");
        map.put("L*+!H", "(0%, +5%)(4%, -7%)(18%,-16%)(34%,-20%)(48%, -7%)(52%, +10%)(66%,+20%)(82%,+26%)(100%,+30%)");
        map.put("L+H*", "(0%, -20%)(18%,-19%)(34%,-17%)(45%, -7%)(55%, +10%)(66%,+25%)(82%,+28%)(100%,+30%)");
        map.put("!H*", "(0%, +30%)(18%,+10%)(34%,+5%)(50%,0%)(66%,-13%)(82%,-17%)(100%,-20%)");
        return map;
    }

    private HashMap<String, String> getToBI2ContourMap(String externalFileName) throws IOException {
        String line;
        BufferedReader bfr = new BufferedReader(new FileReader(new File(externalFileName)));
        HashMap<String, String> map = new HashMap<String, String>();
        while ((line = bfr.readLine()) != null) {
            String[] words;
            if ("".equals(line = line.trim()) || line.startsWith("#") || !line.contains("|") || (words = line.split("\\|")).length != 2) continue;
            map.put(words[0], words[1]);
        }
        return map;
    }

    protected void processSentence(Element sentence) {
        String tone2;
        NodeList tokens = sentence.getElementsByTagName("t");
        if (tokens.getLength() < 1) {
            return;
        }
        Element firstTokenInPhrase = null;
        String sentenceType = "decl";
        sentenceType = this.getSentenceType(tokens);
        boolean paragraphFinal = MaryDomUtils.isLastOfItsKindIn((Node)sentence, "p") && !MaryDomUtils.isFirstOfItsKindIn((Node)sentence, "p");
        boolean inVorfeld = true;
        int i = 0;
        while (i < tokens.getLength()) {
            Element token = (Element)tokens.item(i);
            if (!token.getAttribute("ph").equals("")) {
                String posFirstWord = token.getAttribute("pos");
                Set noVorfeld = (Set)this.listMap.get("noVorfeld");
                if (noVorfeld == null || !noVorfeld.contains(posFirstWord)) break;
                inVorfeld = false;
                break;
            }
            ++i;
        }
        String specialPositionType = "noValue";
        int numEndOfVorfeld = -1;
        boolean hasAccent = false;
        Element bestCandidate = null;
        int i2 = 0;
        while (i2 < tokens.getLength()) {
            boolean applyRules;
            boolean isFinalToken;
            Element token = (Element)tokens.item(i2);
            this.logger.debug("Now looking at token `" + MaryDomUtils.tokenText(token) + "'");
            if (firstTokenInPhrase == null) {
                firstTokenInPhrase = token;
            }
            if (inVorfeld && i2 < tokens.getLength() - 1) {
                Element nextToken = (Element)tokens.item(i2 + 1);
                String posNextToken = nextToken.getAttribute("pos");
                Set beginOfMittelfeld = (Set)this.listMap.get("beginOfMittelfeld");
                if (beginOfMittelfeld != null && beginOfMittelfeld.contains(posNextToken)) {
                    specialPositionType = "endofvorfeld";
                    numEndOfVorfeld = i2;
                    inVorfeld = false;
                } else {
                    specialPositionType = "vorfeld";
                }
            }
            boolean bl = isFinalToken = i2 >= tokens.getLength() - 1;
            if (paragraphFinal && isFinalToken) {
                specialPositionType = "endofpar";
            }
            if (applyRules = this.applyRules(token)) {
                String forceAccent = this.getForceAccent(token);
                if (token.getAttribute("accent").equals("unknown") || !token.hasAttribute("accent") && (forceAccent.equals("word") || forceAccent.equals("syllable"))) {
                    this.setAccent(token, "tone");
                } else if (!token.getAttribute("accent").equals("none") && !forceAccent.equals("none") && token.getAttribute("accent").equals("")) {
                    if (token.getAttribute("ph").equals("")) {
                        token.removeAttribute("accent");
                    } else {
                        this.getAccentPosition(token, tokens, i2, sentenceType, specialPositionType);
                    }
                }
                if (token.hasAttribute("accent") && !token.getAttribute("accent").equals("none")) {
                    hasAccent = true;
                }
                if (!(hasAccent || token.getAttribute("accent").equals("none") || forceAccent.equals("none") || token.getAttribute("ph").equals(""))) {
                    if (bestCandidate == null) {
                        bestCandidate = token;
                    } else {
                        int priorToken = -1;
                        int priorBestCandidate = -1;
                        String posCurrentToken = token.getAttribute("pos");
                        try {
                            priorToken = Integer.parseInt(this.priorities.getProperty(posCurrentToken));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        String posBestCandidate = bestCandidate.getAttribute("pos");
                        try {
                            priorBestCandidate = Integer.parseInt(this.priorities.getProperty(posBestCandidate));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        if (priorToken != -1 && priorBestCandidate != -1 && priorToken <= priorBestCandidate) {
                            bestCandidate = token;
                        }
                    }
                }
                if (token.getAttribute("accent").equals("none") || forceAccent.equals("none")) {
                    token.removeAttribute("accent");
                }
            }
            boolean invalidXML = false;
            if (!isFinalToken) {
                invalidXML = MaryDomUtils.isAncestor(MaryDomUtils.closestCommonAncestor(firstTokenInPhrase, tokens.item(i2)), MaryDomUtils.closestCommonAncestor(tokens.item(i2), tokens.item(i2 + 1)));
            }
            if (applyRules) {
                firstTokenInPhrase = this.getBoundary(token, tokens, i2, sentenceType, specialPositionType, invalidXML, firstTokenInPhrase);
                Element boundary = null;
                Document doc = token.getOwnerDocument();
                TreeWalker tw = ((DocumentTraversal)((Object)doc)).createTreeWalker(DomUtils.getAncestor((Node)token, "s"), 1, new NameNodeFilter("boundary", "t"), false);
                tw.setCurrentNode(token);
                this.logger.debug("Starting treewalker at token " + MaryDomUtils.tokenText(token));
                Element next = (Element)tw.nextNode();
                if (next != null && next.getTagName().equals("boundary")) {
                    this.logger.debug("tw found a boundary");
                    boundary = next;
                    int bi = 0;
                    try {
                        bi = Integer.parseInt(boundary.getAttribute("breakindex"));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    if (bi >= 3) {
                        if (!hasAccent && bestCandidate != null) {
                            this.setAccent(bestCandidate, "tone");
                        }
                        hasAccent = false;
                        bestCandidate = null;
                    }
                }
            }
            if (specialPositionType.equals("endofvorfeld")) {
                specialPositionType = "noValue";
            }
            ++i2;
        }
        NodeList boundaries = sentence.getElementsByTagName("boundary");
        int i3 = 0;
        while (i3 < boundaries.getLength()) {
            Element boundary = (Element)boundaries.item(i3);
            if (boundary.getAttribute("breakindex").equals("none")) {
                Node parent = boundary.getParentNode();
                parent.removeChild(boundary);
            } else if (boundary.getAttribute("tone").equals("unknown")) {
                Set set;
                Element prosody = MaryDomUtils.getClosestAncestorWithAttribute(boundary, "prosody", "preferred-boundary-type");
                String preferred = null;
                if (prosody != null) {
                    preferred = prosody.getAttribute("preferred-boundary-type");
                }
                String h = boundary.getAttribute("breakindex");
                int bi = 0;
                tone2 = null;
                try {
                    bi = Integer.parseInt(h);
                }
                catch (NumberFormatException numberFormatException) {}
                if (bi >= 4) {
                    if (preferred != null) {
                        if (preferred.equals("high")) {
                            set = (Set)this.listMap.get("high_major_boundary");
                            for (String tone2 : set) {
                            }
                        } else {
                            set = (Set)this.listMap.get("low_major_boundary");
                            for (String tone2 : set) {
                            }
                        }
                    } else if (i3 == boundaries.getLength() - 1) {
                        if (sentenceType.equals("decl") || sentenceType.equals("excl")) {
                            set = (Set)this.listMap.get("default_IP_endOfSent");
                            for (String tone2 : set) {
                            }
                        } else {
                            set = (Set)this.listMap.get("default_IP_endOfInterrogSent");
                            for (String tone2 : set) {
                            }
                        }
                    } else {
                        set = (Set)this.listMap.get("default_IP_midOfSent");
                        for (String tone2 : set) {
                        }
                    }
                } else if (bi == 3) {
                    if (preferred != null) {
                        if (preferred.equals("high")) {
                            set = (Set)this.listMap.get("high_minor_boundary");
                            for (String tone2 : set) {
                            }
                        } else {
                            set = (Set)this.listMap.get("low_minor_boundary");
                            for (String tone2 : set) {
                            }
                        }
                    } else {
                        set = (Set)this.listMap.get("default_ip");
                        for (String tone2 : set) {
                        }
                    }
                }
                if (tone2 != null) {
                    boundary.setAttribute("tone", tone2);
                }
            }
            ++i3;
        }
        boolean nucleusAssigned = false;
        String lastAssignedTone = null;
        int j = tokens.getLength() - 1;
        while (j >= 0) {
            boolean isFinalToken;
            Element token = (Element)tokens.item(j);
            boolean bl = isFinalToken = j >= tokens.getLength() - 1;
            if (paragraphFinal && isFinalToken) {
                specialPositionType = "endofpar";
            }
            if (j == numEndOfVorfeld) {
                specialPositionType = "endofvorfeld";
            }
            if (token.getAttribute("accent").equals("tone") || token.getAttribute("accent").equals("force")) {
                Element prosody = MaryDomUtils.getClosestAncestorWithAttribute(token, "prosody", "preferred-accent-shape");
                if (prosody != null) {
                    if (token.getAttribute("accent").equals("tone")) {
                        Set set;
                        Iterator it;
                        tone2 = null;
                        String preferred = prosody.getAttribute("preferred-accent-shape");
                        if (preferred.equals("alternating")) {
                            Set set2 = (Set)this.listMap.get("alternating_accents");
                            it = set2.iterator();
                            while (it.hasNext()) {
                                String next = (String)it.next();
                                if (lastAssignedTone != null && lastAssignedTone.equals(next)) continue;
                                tone2 = next;
                            }
                        } else if (preferred.equals("rising")) {
                            Set set3 = (Set)this.listMap.get("rising_accents");
                            it = set3.iterator();
                            if (it.hasNext()) {
                                tone2 = (String)it.next();
                            }
                        } else if (preferred.equals("falling") && (it = (set = (Set)this.listMap.get("falling_accents")).iterator()).hasNext()) {
                            tone2 = (String)it.next();
                        }
                        token.setAttribute("accent", tone2);
                        if (!nucleusAssigned) {
                            nucleusAssigned = true;
                        }
                    }
                } else if (!(token.getAttribute("accent").equals("force") || token.getAttribute("accent").equals("tone") || token.getAttribute("accent").equals(""))) {
                    nucleusAssigned = true;
                } else if (!token.getAttribute("ph").equals("")) {
                    nucleusAssigned = this.getAccentShape(token, tokens, j, sentenceType, specialPositionType, nucleusAssigned);
                }
            }
            if (token.getAttribute("accent").equals("") || token.getAttribute("accent").equals("force")) {
                token.removeAttribute("accent");
            }
            if (token.hasAttribute("accent")) {
                lastAssignedTone = token.getAttribute("accent");
            }
            --j;
        }
    }

    protected synchronized void getAccentPosition(Element token, NodeList tokens, int position, String sentenceType, String specialPositionType) {
        String tokenText = MaryDomUtils.tokenText(token);
        Element ruleList = null;
        ruleList = this.tobiPredMap.get("accentposition");
        TreeWalker tw = ((DocumentTraversal)((Object)ruleList.getOwnerDocument())).createTreeWalker(ruleList, 1, new NameNodeFilter("rule"), false);
        boolean rule_fired = false;
        String accent = "";
        Element rule = null;
        block0: while (!rule_fired && (rule = (Element)tw.nextNode()) != null) {
            Element currentRulePart = DomUtils.getFirstChildElement(rule);
            while (!rule_fired && currentRulePart != null) {
                boolean conditionSatisfied = false;
                if (currentRulePart.getTagName().equals("action")) {
                    accent = currentRulePart.getAttribute("accent");
                    token.setAttribute("accent", accent);
                    rule_fired = true;
                    continue block0;
                }
                conditionSatisfied = this.checkRulePart(currentRulePart, token, tokens, position, sentenceType, specialPositionType, tokenText);
                if (!conditionSatisfied) continue block0;
                currentRulePart = DomUtils.getNextSiblingElement(currentRulePart);
            }
        }
    }

    protected synchronized boolean getAccentShape(Element token, NodeList tokens, int position, String sentenceType, String specialPositionType, boolean nucleusAssigned) {
        String tokenText = MaryDomUtils.tokenText(token);
        String prosodicPositionType = null;
        prosodicPositionType = !nucleusAssigned ? (token.getAttribute("accent").equals("tone") ? (specialPositionType.equals("endofpar") ? "nuclearParagraphFinal" : "nuclearNonParagraphFinal") : "postnuclear") : "prenuclear";
        Element ruleList = null;
        ruleList = this.tobiPredMap.get("accentshape");
        TreeWalker tw = ((DocumentTraversal)((Object)ruleList.getOwnerDocument())).createTreeWalker(ruleList, 1, new NameNodeFilter("rule"), false);
        boolean rule_fired = false;
        String accent = "";
        Element rule = null;
        block0: while (!rule_fired && (rule = (Element)tw.nextNode()) != null) {
            Element currentRulePart = DomUtils.getFirstChildElement(rule);
            while (!rule_fired && currentRulePart != null) {
                boolean conditionSatisfied = false;
                if (currentRulePart.getTagName().equals("action")) {
                    accent = currentRulePart.getAttribute("accent");
                    token.setAttribute("accent", accent);
                    rule_fired = true;
                    if (nucleusAssigned || accent.equals("*")) continue block0;
                    nucleusAssigned = true;
                    continue block0;
                }
                if (currentRulePart.getTagName().equals("prosodicPosition") && !this.checkProsodicPosition(currentRulePart, prosodicPositionType) || !(conditionSatisfied = this.checkRulePart(currentRulePart, token, tokens, position, sentenceType, specialPositionType, tokenText))) continue block0;
                currentRulePart = DomUtils.getNextSiblingElement(currentRulePart);
            }
        }
        return nucleusAssigned;
    }

    protected synchronized Element getBoundary(Element token, NodeList tokens, int position, String sentenceType, String specialPositionType, boolean invalidXML, Element firstTokenInPhrase) {
        String tokenText = MaryDomUtils.tokenText(token);
        Element ruleList = null;
        ruleList = this.tobiPredMap.get("boundaries");
        TreeWalker tw = ((DocumentTraversal)((Object)ruleList.getOwnerDocument())).createTreeWalker(ruleList, 1, new NameNodeFilter("rule"), false);
        boolean rule_fired = false;
        Element rule = null;
        block0: while (!rule_fired && (rule = (Element)tw.nextNode()) != null) {
            Element currentRulePart = DomUtils.getFirstChildElement(rule);
            while (!rule_fired && currentRulePart != null) {
                boolean conditionSatisfied = false;
                if (currentRulePart.getTagName().equals("action")) {
                    int bi = Integer.parseInt(currentRulePart.getAttribute("bi"));
                    if (bi != 0) {
                        if (currentRulePart.hasAttribute("tone")) {
                            String tone = currentRulePart.getAttribute("tone");
                            if (tone.endsWith("%")) {
                                Element boundary;
                                if (!invalidXML && (boundary = this.insertMajorBoundary(tokens, position, firstTokenInPhrase, tone, bi)) != null) {
                                    firstTokenInPhrase = null;
                                }
                            } else if (tone.endsWith("-")) {
                                this.insertBoundary(token, tone, bi);
                            } else {
                                this.insertBoundary(token, null, bi);
                            }
                        } else {
                            this.insertBoundary(token, null, bi);
                        }
                    }
                    rule_fired = true;
                    continue block0;
                }
                conditionSatisfied = this.checkRulePart(currentRulePart, token, tokens, position, sentenceType, specialPositionType, tokenText);
                if (!conditionSatisfied) continue block0;
                currentRulePart = DomUtils.getNextSiblingElement(currentRulePart);
            }
        }
        return firstTokenInPhrase;
    }

    protected boolean checkRulePart(Element currentRulePart, Element token, NodeList tokens, int position, String sentenceType, String specialPositionType, String tokenText) {
        String currentRulePartTagName = currentRulePart.getTagName();
        if (currentRulePartTagName.equals("text") & currentRulePart.hasAttribute("word")) {
            return this.checkText(currentRulePart, tokenText);
        }
        if (currentRulePart.hasAttribute("word") && (currentRulePartTagName.equals("nextText") || nextPlusXTextPattern.matcher(currentRulePartTagName).find() || currentRulePartTagName.equals("previousText") || previousMinusXTextPattern.matcher(currentRulePartTagName).find())) {
            return this.checkTextOfOtherToken(currentRulePartTagName, currentRulePart, position, tokens);
        }
        if (currentRulePartTagName.equals("folTokens") && currentRulePart.hasAttribute("num")) {
            return this.checkFolTokens(currentRulePart, position, tokens);
        }
        if (currentRulePartTagName.equals("prevTokens") && currentRulePart.hasAttribute("num")) {
            return this.checkPrevTokens(currentRulePart, position, tokens);
        }
        if (currentRulePartTagName.equals("folWords") && currentRulePart.hasAttribute("num")) {
            return this.checkFolWords(currentRulePart, position, tokens);
        }
        if (currentRulePartTagName.equals("prevWords") && currentRulePart.hasAttribute("num")) {
            return this.checkPrevWords(currentRulePart, position, tokens);
        }
        if (currentRulePartTagName.equals("sentence") && currentRulePart.hasAttribute("type")) {
            return this.checkSentence(currentRulePart, sentenceType);
        }
        if (currentRulePartTagName.equals("specialPosition") && currentRulePart.hasAttribute("type")) {
            return this.checkSpecialPosition(currentRulePart, specialPositionType);
        }
        if (currentRulePartTagName.equals("attributes")) {
            return this.checkAttributes(currentRulePart, token);
        }
        if (currentRulePartTagName.equals("nextAttributes") || nextPlusXAttributesPattern.matcher(currentRulePart.getTagName()).find() || currentRulePartTagName.equals("previousAttributes") || previousMinusXAttributesPattern.matcher(currentRulePart.getTagName()).find()) {
            return this.checkAttributesOfOtherToken(currentRulePart.getTagName(), currentRulePart, position, tokens);
        }
        return true;
    }

    protected boolean checkText(Element currentRulePart, String tokenText) {
        NamedNodeMap attNodes = currentRulePart.getAttributes();
        int z = 0;
        while (z < attNodes.getLength()) {
            Node el = attNodes.item(z);
            String currentAtt = el.getNodeName();
            String currentVal = el.getNodeValue();
            if (currentAtt.equals("word")) {
                if (!(currentVal.startsWith("INLIST") || currentVal.startsWith("INFSTLIST") || currentVal.startsWith("!INLIST") || currentVal.startsWith("!INFSTLIST"))) {
                    if (!currentVal.startsWith("!") ? !tokenText.equals(currentVal) : tokenText.equals(currentVal = currentVal.substring(1, currentVal.length()))) {
                        return false;
                    }
                } else {
                    return this.checkList(currentVal, tokenText);
                }
            }
            ++z;
        }
        return true;
    }

    protected boolean checkTextOfOtherToken(String tag, Element currentRulePart, int position, NodeList tokens) {
        int num;
        String newString;
        String tempString;
        Element otherToken = null;
        if (tag.equals("nextText") && position < tokens.getLength() - 1) {
            otherToken = (Element)tokens.item(position + 1);
        }
        if (nextPlusXTextPattern.matcher(tag).find()) {
            tempString = tag.replaceAll("nextPlus", "");
            newString = tempString.replaceAll("Text", "");
            num = Integer.parseInt(newString);
            if (position < tokens.getLength() - (num + 1)) {
                otherToken = (Element)tokens.item(position + 1 + num);
            }
        }
        if (tag.equals("previousText") && position > 0) {
            otherToken = (Element)tokens.item(position - 1);
        }
        if (previousMinusXTextPattern.matcher(tag).find() && position > (num = Integer.parseInt(newString = (tempString = tag.replaceAll("previousMinus", "")).replaceAll("Text", "")))) {
            otherToken = (Element)tokens.item(position - (num + 1));
        }
        if (otherToken == null) {
            return false;
        }
        String otherTokenText = MaryDomUtils.tokenText(otherToken);
        return this.checkText(currentRulePart, otherTokenText);
    }

    protected boolean checkFolTokens(Element currentRulePart, int position, NodeList tokens) {
        NamedNodeMap attNodes = currentRulePart.getAttributes();
        int z = 0;
        while (z < attNodes.getLength()) {
            Node el = attNodes.item(z);
            String currentAtt = el.getNodeName();
            String currentVal = el.getNodeValue();
            if (currentAtt.equals("num")) {
                int num = Integer.parseInt(currentVal.substring(0, 1));
                int requiredLastTokenPosition = position + num;
                if (currentVal.length() == 1 ? tokens.getLength() - 1 != requiredLastTokenPosition : (currentVal.substring(1, 2).equals("+") ? tokens.getLength() - 1 < requiredLastTokenPosition : currentVal.substring(1, 2).equals("-") && tokens.getLength() - 1 > requiredLastTokenPosition)) {
                    return false;
                }
            }
            ++z;
        }
        return true;
    }

    protected boolean checkPrevTokens(Element currentRulePart, int position, NodeList tokens) {
        NamedNodeMap attNodes = currentRulePart.getAttributes();
        int z = 0;
        while (z < attNodes.getLength()) {
            Node el = attNodes.item(z);
            String currentAtt = el.getNodeName();
            String currentVal = el.getNodeValue();
            if (currentAtt.equals("num")) {
                int num = Integer.parseInt(currentVal.substring(0, 1));
                int requiredFirstTokenPosition = position - num;
                if (currentVal.length() == 1 ? requiredFirstTokenPosition != 0 : (currentVal.substring(1, 2).equals("+") ? requiredFirstTokenPosition < 0 : currentVal.substring(1, 2).equals("-") && requiredFirstTokenPosition > 0)) {
                    return false;
                }
            }
            ++z;
        }
        return true;
    }

    protected boolean checkFolWords(Element currentRulePart, int position, NodeList tokens) {
        NamedNodeMap attNodes = currentRulePart.getAttributes();
        int z = 0;
        while (z < attNodes.getLength()) {
            Node el = attNodes.item(z);
            String currentAtt = el.getNodeName();
            String currentVal = el.getNodeValue();
            if (currentAtt.equals("num")) {
                int requiredNum = Integer.parseInt(currentVal.substring(0, 1));
                int num = 0;
                int i = position + 1;
                while (i < tokens.getLength()) {
                    if (!((Element)tokens.item(i)).getAttribute("ph").equals("")) {
                        ++num;
                    }
                    ++i;
                }
                if (currentVal.length() == 1 ? num != requiredNum : (currentVal.substring(1, 2).equals("+") ? num < requiredNum : currentVal.substring(1, 2).equals("-") && num > requiredNum)) {
                    return false;
                }
            }
            ++z;
        }
        return true;
    }

    protected boolean checkPrevWords(Element currentRulePart, int position, NodeList tokens) {
        NamedNodeMap attNodes = currentRulePart.getAttributes();
        int z = 0;
        while (z < attNodes.getLength()) {
            Node el = attNodes.item(z);
            String currentAtt = el.getNodeName();
            String currentVal = el.getNodeValue();
            if (currentAtt.equals("num")) {
                int requiredNum = Integer.parseInt(currentVal.substring(0, 1));
                int num = 0;
                int i = position - 1;
                while (i >= 0) {
                    if (!((Element)tokens.item(i)).getAttribute("ph").equals("")) {
                        ++num;
                    }
                    --i;
                }
                if (currentVal.length() == 1 ? num != requiredNum : (currentVal.substring(1, 2).equals("+") ? num < requiredNum : currentVal.substring(1, 2).equals("-") && num > requiredNum)) {
                    return false;
                }
            }
            ++z;
        }
        return true;
    }

    protected boolean checkSentence(Element currentRulePart, String sentenceType) {
        NamedNodeMap attNodes = currentRulePart.getAttributes();
        int z = 0;
        while (z < attNodes.getLength()) {
            Node el = attNodes.item(z);
            String currentAtt = el.getNodeName();
            String currentVal = el.getNodeValue();
            if (currentAtt.equals("type") && (!currentVal.startsWith("!") ? !sentenceType.equals(currentVal) : sentenceType.equals(currentVal = currentVal.substring(1, currentVal.length())))) {
                return false;
            }
            ++z;
        }
        return true;
    }

    protected boolean checkSpecialPosition(Element currentRulePart, String specialPositionType) {
        NamedNodeMap attNodes = currentRulePart.getAttributes();
        int z = 0;
        while (z < attNodes.getLength()) {
            Node el = attNodes.item(z);
            String currentAtt = el.getNodeName();
            String currentVal = el.getNodeValue();
            if (currentAtt.equals("type") && (!currentVal.startsWith("!") ? !specialPositionType.equals(currentVal) : specialPositionType.equals(currentVal = currentVal.substring(1, currentVal.length())))) {
                return false;
            }
            ++z;
        }
        return true;
    }

    protected boolean checkProsodicPosition(Element currentRulePart, String prosodicPositionType) {
        NamedNodeMap attNodes = currentRulePart.getAttributes();
        int z = 0;
        while (z < attNodes.getLength()) {
            Node el = attNodes.item(z);
            String currentAtt = el.getNodeName();
            String currentVal = el.getNodeValue();
            if (currentAtt.equals("type") && (!currentVal.startsWith("!") ? !prosodicPositionType.equals(currentVal) : prosodicPositionType.equals(currentVal = currentVal.substring(1, currentVal.length())))) {
                return false;
            }
            ++z;
        }
        return true;
    }

    protected boolean checkAttributes(Element currentRulePart, Element token) {
        NamedNodeMap attNodes = currentRulePart.getAttributes();
        if (token == null) {
            return false;
        }
        int z = 0;
        while (z < attNodes.getLength()) {
            Node el = attNodes.item(z);
            String currentAtt = el.getNodeName();
            String currentVal = el.getNodeValue();
            if (!token.hasAttribute(currentAtt)) {
                return currentVal.equals("!");
            }
            if (currentVal.equals("!")) {
                return false;
            }
            if (currentVal.equals("")) {
                return true;
            }
            if (!(currentVal.startsWith("INLIST") || currentVal.startsWith("INFSTLIST") || currentVal.startsWith("!INLIST") || currentVal.startsWith("!INFSTLIST"))) {
                if (!currentVal.startsWith("!")) {
                    if (!token.getAttribute(currentAtt).equals(currentVal)) {
                        return false;
                    }
                } else {
                    currentVal = currentVal.substring(1, currentVal.length());
                    if (token.getAttribute(currentAtt).equals(currentVal)) {
                        return false;
                    }
                }
            } else {
                return this.checkList(currentVal, token.getAttribute(currentAtt));
            }
            ++z;
        }
        return true;
    }

    protected boolean checkAttributesOfOtherToken(String tag, Element currentRulePart, int position, NodeList tokens) {
        int num;
        String newString;
        String tempString;
        Element otherToken = null;
        if (tag.equals("nextAttributes") && position < tokens.getLength() - 1) {
            otherToken = (Element)tokens.item(position + 1);
        }
        if (nextPlusXAttributesPattern.matcher(tag).find()) {
            tempString = tag.replaceAll("nextPlus", "");
            newString = tempString.replaceAll("Attributes", "");
            num = Integer.parseInt(newString);
            if (position < tokens.getLength() - (num + 1)) {
                otherToken = (Element)tokens.item(position + 1 + num);
            }
        }
        if (tag.equals("previousAttributes") && position > 0) {
            otherToken = (Element)tokens.item(position - 1);
        }
        if (previousMinusXAttributesPattern.matcher(tag).find() && position > (num = Integer.parseInt(newString = (tempString = tag.replaceAll("previousMinus", "")).replaceAll("Attributes", "")))) {
            otherToken = (Element)tokens.item(position - (num + 1));
        }
        return this.checkAttributes(currentRulePart, otherToken);
    }

    protected boolean checkList(String currentVal, String tokenValue) {
        if (currentVal == null || tokenValue == null) {
            throw new NullPointerException("Received null argument");
        }
        if (!currentVal.startsWith("INLIST") && !currentVal.startsWith("!INLIST")) {
            throw new IllegalArgumentException("currentVal does not start with INLIST or !INLIST");
        }
        boolean negation = currentVal.startsWith("!");
        String listName = currentVal.substring(currentVal.indexOf(":") + 1);
        Object listObj = this.listMap.get(listName);
        if (listObj == null) {
            return false;
        }
        if (!(listObj instanceof Set)) {
            throw new IllegalArgumentException("Unknown list representation: " + listObj);
        }
        Set set = (Set)listObj;
        boolean contains = set.contains(tokenValue);
        return !(contains && negation || !contains && !negation);
    }

    protected String getSentenceType(NodeList tokens) {
        Element t;
        String sentenceType = "decl";
        int i = tokens.getLength() - 1;
        while (i >= 0) {
            t = (Element)tokens.item(i);
            String punct = MaryDomUtils.tokenText(t);
            if (punct.equals(".")) {
                sentenceType = "decl";
                break;
            }
            if (punct.equals("!")) {
                sentenceType = "excl";
                break;
            }
            if (punct.equals("?")) {
                sentenceType = "interrog";
                break;
            }
            --i;
        }
        if (sentenceType.equals("interrog")) {
            i = 0;
            while (i < tokens.getLength() - 1) {
                t = (Element)tokens.item(i);
                if (!t.getAttribute("ph").equals("")) {
                    Element firstToken = (Element)tokens.item(i);
                    Set setInterrogYN = (Set)this.listMap.get("firstPosInQuestionYN");
                    Set setInterrogW = (Set)this.listMap.get("firstPosInQuestionW");
                    String posFirstWord = firstToken.getAttribute("pos");
                    if (setInterrogYN != null && setInterrogYN.contains(posFirstWord)) {
                        sentenceType = "interrogYN";
                    }
                    if (setInterrogW == null || !setInterrogW.contains(posFirstWord)) break;
                    sentenceType = "interrogW";
                    break;
                }
                ++i;
            }
        }
        return sentenceType;
    }

    protected void setAccent(Element token, String accent) {
        token.setAttribute("accent", accent);
    }

    protected Element insertBoundary(Element token, String tone, int bi) {
        Element boundary = null;
        this.logger.debug("insertBoundary: after token `" + MaryDomUtils.tokenText(token) + "', tone " + tone + ", bi " + bi);
        Document doc = token.getOwnerDocument();
        TreeWalker tw = ((DocumentTraversal)((Object)doc)).createTreeWalker(DomUtils.getAncestor((Node)token, "s"), 1, new NameNodeFilter("boundary", "t"), false);
        tw.setCurrentNode(token);
        Element next = (Element)tw.nextNode();
        if (next != null && next.getTagName().equals("boundary")) {
            boundary = next;
        } else if (this.isPunctuation(token)) {
            tw.setCurrentNode(token);
            Element prev = (Element)tw.previousNode();
            if (prev != null && prev.getTagName().equals("boundary")) {
                boundary = prev;
            }
        }
        if (boundary != null && boundary.getParentNode().equals(token.getParentNode())) {
            String tagBIString;
            String tagTone;
            if (tone != null && ((tagTone = boundary.getAttribute("tone")).equals("") || !tone.equals("unknown") && tagTone.equals("unknown"))) {
                boundary.setAttribute("tone", tone);
            }
            if (bi > 0 && ((tagBIString = boundary.getAttribute("breakindex")).equals("") || tagBIString.equals("unknown"))) {
                boundary.setAttribute("breakindex", String.valueOf(bi));
            }
        } else {
            if (token.getParentNode() == null) {
                return null;
            }
            Element eIn = (Element)token.getParentNode();
            Element eBefore = MaryDomUtils.getNextSiblingElement(token);
            Element mtu = (Element)MaryDomUtils.getHighestLevelAncestor(token, "mtu");
            if (mtu != null) {
                if (MaryDomUtils.isLastOfItsKindIn((Node)token, mtu)) {
                    eIn = (Element)mtu.getParentNode();
                    eBefore = MaryDomUtils.getNextSiblingElement(mtu);
                } else {
                    return null;
                }
            }
            boundary = MaryXML.createElement(doc, "boundary");
            if (tone != null) {
                boundary.setAttribute("tone", tone);
            }
            if (bi > 0) {
                boundary.setAttribute("breakindex", String.valueOf(bi));
            }
            eIn.insertBefore(boundary, eBefore);
        }
        return boundary;
    }

    protected Element insertMajorBoundary(NodeList tokens, int i, Element firstToken, String tone, int breakindex) {
        Element boundary = this.insertBoundary((Element)tokens.item(i), tone, breakindex);
        this.insertPhraseNode(firstToken, boundary);
        return boundary;
    }

    protected boolean insertPhraseNode(Element first, Element last) {
        Element phrase;
        Element encloseFromHere = first;
        Element maybeBoundary = DomUtils.getPreviousSiblingElement(first);
        if (maybeBoundary != null && maybeBoundary.getTagName().equals("boundary")) {
            encloseFromHere = maybeBoundary;
        }
        Element encloseToHere = last;
        maybeBoundary = DomUtils.getNextSiblingElement(last);
        if (maybeBoundary != null && maybeBoundary.getTagName().equals("boundary")) {
            encloseToHere = maybeBoundary;
        }
        return (phrase = MaryDomUtils.encloseNodesWithNewElement(encloseFromHere, encloseToHere, "phrase")) != null;
    }

    protected boolean applyRules(Node n) {
        Element intonation = (Element)MaryDomUtils.getAncestor(n, "prosody");
        return intonation == null || !intonation.getAttribute("rules").equals("off");
    }

    protected void copyAccentsToSyllables(Document doc) {
        NodeIterator tIt = ((DocumentTraversal)((Object)doc)).createNodeIterator(doc, 1, new NameNodeFilter("t"), false);
        Element t = null;
        while ((t = (Element)tIt.nextNode()) != null) {
            if (!t.hasAttribute("accent")) continue;
            NodeIterator sylIt = ((DocumentTraversal)((Object)doc)).createNodeIterator(t, 1, new NameNodeFilter("syllable"), false);
            boolean assignedAccent = false;
            Element syl = null;
            while ((syl = (Element)sylIt.nextNode()) != null) {
                if (!syl.getAttribute("stress").equals("1")) continue;
                syl.setAttribute("accent", t.getAttribute("accent"));
                assignedAccent = true;
                break;
            }
            if (assignedAccent || (syl = MaryDomUtils.getFirstElementByTagName(t, "syllable")) == null) continue;
            syl.setAttribute("accent", t.getAttribute("accent"));
        }
    }

    protected String getForceAccent(Element token) {
        Element p = MaryDomUtils.getClosestAncestorWithAttribute(token, "prosody", "force-accent");
        if (p != null) {
            return p.getAttribute("force-accent");
        }
        return "";
    }

    protected boolean isPunctuation(Element token) {
        if (token == null) {
            throw new NullPointerException("Received null token");
        }
        if (!token.getTagName().equals("t")) {
            throw new IllegalArgumentException("Expected <t> element, got <" + token.getTagName() + ">");
        }
        String tokenText = MaryDomUtils.tokenText(token);
        return tokenText.equals(",") || tokenText.equals(".") || tokenText.equals("?") || tokenText.equals("!") || tokenText.equals(":") || tokenText.equals(";");
    }
}

