/*
 * Decompiled with CFR 0.152.
 */
package marytts.htsengine;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import marytts.htsengine.CartTreeSet;
import marytts.htsengine.GVModelSet;
import marytts.htsengine.HMMData;
import marytts.htsengine.HTSModel;
import marytts.htsengine.HTSPStream;
import marytts.htsengine.HTSUttModel;
import marytts.signalproc.analysis.Mfccs;
import marytts.signalproc.analysis.PitchReaderWriter;
import marytts.util.MaryUtils;
import org.apache.log4j.Logger;

public class HTSParameterGeneration {
    public static final double INFTY = 1.0E38;
    public static final double INFTY2 = 1.0E19;
    public static final double INVINF = 1.0E-38;
    public static final double INVINF2 = 1.0E-19;
    private HTSPStream mcepPst = null;
    private HTSPStream strPst = null;
    private HTSPStream magPst = null;
    private HTSPStream lf0Pst = null;
    private boolean[] voiced;
    private int totalUttFrame;
    private int totalLf0Frame;
    private Logger logger = MaryUtils.getLogger("ParameterGeneration");

    public HTSPStream getMcepPst() {
        return this.mcepPst;
    }

    public void setMcepPst(HTSPStream var) {
        this.mcepPst = var;
    }

    public HTSPStream getStrPst() {
        return this.strPst;
    }

    public void setStrPst(HTSPStream var) {
        this.strPst = var;
    }

    public HTSPStream getMagPst() {
        return this.magPst;
    }

    public void setMagPst(HTSPStream var) {
        this.magPst = var;
    }

    public HTSPStream getlf0Pst() {
        return this.lf0Pst;
    }

    public void setlf0Pst(HTSPStream var) {
        this.lf0Pst = var;
    }

    public boolean[] getVoicedArray() {
        return this.voiced;
    }

    public void setVoicedArray(boolean[] var) {
        this.voiced = var;
    }

    public static double finv(double x) {
        if (x >= 1.0E19) {
            return 0.0;
        }
        if (x <= -1.0E19) {
            return 0.0;
        }
        if (x <= 1.0E-19 && x >= 0.0) {
            return 1.0E38;
        }
        if (x >= -1.0E-19 && x < 0.0) {
            return -1.0E38;
        }
        return 1.0 / x;
    }

    public void htsMaximumLikelihoodParameterGeneration(HTSUttModel um, HMMData htsData) throws Exception {
        HTSModel m;
        CartTreeSet ms = htsData.getCartTreeSet();
        if (htsData.getPdfMgcStream() != null) {
            this.mcepPst = new HTSPStream(ms.getMcepVsize(), um.getTotalFrame(), HMMData.FeatureType.MGC, htsData.getMaxMgcGvIter());
        }
        if (htsData.getPdfLf0Stream() != null) {
            this.lf0Pst = new HTSPStream(ms.getLf0Stream(), um.getLf0Frame(), HMMData.FeatureType.LF0, htsData.getMaxLf0GvIter());
        }
        if (htsData.getPdfStrStream() != null) {
            this.strPst = new HTSPStream(ms.getStrVsize(), um.getTotalFrame(), HMMData.FeatureType.STR, htsData.getMaxStrGvIter());
        }
        if (htsData.getPdfMagStream() != null) {
            this.magPst = new HTSPStream(ms.getMagVsize(), um.getTotalFrame(), HMMData.FeatureType.MAG, htsData.getMaxMagGvIter());
        }
        int lf0Frame = 0;
        int uttFrame = 0;
        this.voiced = new boolean[um.getTotalFrame()];
        int msNumStates = ms.getNumStates();
        int totalFrames = um.getTotalFrame();
        int i = 0;
        while (i < um.getNumUttModel()) {
            m = um.getUttModel(i);
            int state = 0;
            while (state < msNumStates) {
                int dur = m.getDur(state);
                Arrays.fill(this.voiced, uttFrame, uttFrame += dur, m.getVoiced(state));
                if (m.getVoiced(state)) {
                    lf0Frame += dur;
                }
                ++state;
            }
            ++i;
        }
        this.logger.debug("utteranceFrame=" + uttFrame + " lf0frame=" + lf0Frame);
        uttFrame = 0;
        lf0Frame = 0;
        i = 0;
        while (i < um.getNumUttModel()) {
            m = um.getUttModel(i);
            boolean gvSwitch = m.getGvSwitch();
            int state = 0;
            while (state < msNumStates) {
                int frame = 0;
                while (frame < m.getDur(state)) {
                    if (this.mcepPst != null) {
                        this.mcepPst.setMseq(uttFrame, m.getMean(HMMData.FeatureType.MGC, state));
                        this.mcepPst.setVseq(uttFrame, m.getVariance(HMMData.FeatureType.MGC, state));
                        if (!gvSwitch) {
                            this.mcepPst.setGvSwitch(uttFrame, false);
                        }
                    }
                    if (this.strPst != null) {
                        this.strPst.setMseq(uttFrame, m.getMean(HMMData.FeatureType.STR, state));
                        this.strPst.setVseq(uttFrame, m.getVariance(HMMData.FeatureType.STR, state));
                        if (!gvSwitch) {
                            this.strPst.setGvSwitch(uttFrame, false);
                        }
                    }
                    if (this.magPst != null) {
                        this.magPst.setMseq(uttFrame, m.getMean(HMMData.FeatureType.MAG, state));
                        this.magPst.setVseq(uttFrame, m.getVariance(HMMData.FeatureType.MAG, state));
                        if (!gvSwitch) {
                            this.magPst.setGvSwitch(uttFrame, false);
                        }
                    }
                    if (this.lf0Pst != null && !htsData.getUseAcousticModels()) {
                        int k = 0;
                        while (k < ms.getLf0Stream()) {
                            boolean nobound = true;
                            int n = this.lf0Pst.getDWLeftBoundary(k);
                            while (n <= this.lf0Pst.getDWRightBoundary(k)) {
                                nobound = uttFrame + n <= 0 || totalFrames <= uttFrame + n ? false : nobound && this.voiced[uttFrame + n];
                                ++n;
                            }
                            if (this.voiced[uttFrame]) {
                                this.lf0Pst.setMseq(lf0Frame, k, m.getLf0Mean(state, k));
                                if (nobound || k == 0) {
                                    this.lf0Pst.setIvseq(lf0Frame, k, HTSParameterGeneration.finv(m.getLf0Variance(state, k)));
                                } else {
                                    this.lf0Pst.setIvseq(lf0Frame, k, 0.0);
                                }
                            }
                            ++k;
                        }
                    }
                    if (this.voiced[uttFrame]) {
                        if (!gvSwitch) {
                            this.lf0Pst.setGvSwitch(lf0Frame, false);
                        }
                        ++lf0Frame;
                    }
                    ++uttFrame;
                    ++frame;
                }
                ++state;
            }
            ++i;
        }
        GVModelSet gvms = htsData.getGVModelSet();
        if (this.mcepPst != null) {
            this.mcepPst.fixDynFeatOnBoundaries();
        }
        if (this.strPst != null) {
            this.strPst.fixDynFeatOnBoundaries();
        }
        if (this.magPst != null) {
            this.magPst.fixDynFeatOnBoundaries();
        }
        if (this.mcepPst != null) {
            this.logger.info("Parameter generation for MGC: ");
            if (htsData.getUseGV() && htsData.getPdfMgcGVStream() != null) {
                this.mcepPst.setGvMeanVar(gvms.getGVmeanMgc(), gvms.getGVcovInvMgc());
            }
            this.mcepPst.mlpg(htsData, htsData.getUseGV());
        }
        if (htsData.getUseAcousticModels()) {
            this.loadMaryXmlF0(um, htsData);
        } else if (this.lf0Pst != null) {
            this.logger.info("Parameter generation for LF0: ");
            if (htsData.getUseGV() && htsData.getPdfLf0GVStream() != null) {
                this.lf0Pst.setGvMeanVar(gvms.getGVmeanLf0(), gvms.getGVcovInvLf0());
            }
            this.lf0Pst.mlpg(htsData, htsData.getUseGV());
            this.setRealisedF0(this.lf0Pst, um, msNumStates);
        }
        boolean useGV = false;
        if (this.strPst != null) {
            this.logger.debug("Parameter generation for STR ");
            if (htsData.getUseGV() && htsData.getPdfStrGVStream() != null) {
                useGV = true;
                this.strPst.setGvMeanVar(gvms.getGVmeanStr(), gvms.getGVcovInvStr());
            }
            this.strPst.mlpg(htsData, useGV);
        }
        useGV = false;
        if (this.magPst != null) {
            this.logger.info("Parameter generation for MAG ");
            if (htsData.getUseGV() && htsData.getPdfMagGVStream() != null) {
                useGV = true;
                this.magPst.setGvMeanVar(gvms.getGVmeanMag(), gvms.getGVcovInvMag());
            }
            this.magPst.mlpg(htsData, useGV);
        }
    }

    public void saveParamMaryFormat(String fileName, HTSPStream par, HMMData.FeatureType type) {
        double ws = 0.025;
        double ss = 0.005;
        int fs = 16000;
        try {
            if (type == HMMData.FeatureType.LF0) {
                fileName = String.valueOf(fileName) + ".ptc";
                int i = 0;
                double[] f0s = new double[this.voiced.length];
                int t = 0;
                while (t < this.voiced.length) {
                    if (this.voiced[t]) {
                        f0s[t] = Math.exp(par.getPar(i, 0));
                        ++i;
                    } else {
                        f0s[t] = 0.0;
                    }
                    System.out.println("GEN f0s[" + t + "]=" + f0s[t]);
                    ++t;
                }
                PitchReaderWriter.write_pitch_file(fileName, f0s, (float)ws, (float)ss, fs);
            } else if (type == HMMData.FeatureType.MGC) {
                int numfrm = par.getT();
                int dimension = par.getOrder();
                Mfccs mgc = new Mfccs(numfrm, dimension);
                fileName = String.valueOf(fileName) + ".mfc";
                int t = 0;
                while (t < par.getT()) {
                    int m = 0;
                    while (m < par.getOrder()) {
                        mgc.mfccs[t][m] = par.getPar(t, m);
                        ++m;
                    }
                    ++t;
                }
                mgc.params.samplingRate = fs;
                mgc.params.skipsize = (float)ss;
                mgc.params.winsize = (float)ws;
                mgc.writeMfccFile(fileName);
            }
            this.logger.info("saveParam in file: " + fileName);
        }
        catch (IOException e) {
            this.logger.info("IO exception = " + e);
        }
    }

    public void saveParam(String fileName, HTSPStream par, HMMData.FeatureType type) {
        try {
            if (type == HMMData.FeatureType.LF0) {
                fileName = String.valueOf(fileName) + ".f0";
                DataOutputStream data_out = new DataOutputStream(new FileOutputStream(fileName));
                int i = 0;
                int t = 0;
                while (t < this.voiced.length) {
                    if (this.voiced[t]) {
                        data_out.writeFloat((float)Math.exp(par.getPar(i, 0)));
                        ++i;
                    } else {
                        data_out.writeFloat(0.0f);
                    }
                    ++t;
                }
                data_out.close();
            } else if (type == HMMData.FeatureType.MGC) {
                fileName = String.valueOf(fileName) + ".mgc";
                DataOutputStream data_out = new DataOutputStream(new FileOutputStream(fileName));
                int t = 0;
                while (t < par.getT()) {
                    int m = 0;
                    while (m < par.getOrder()) {
                        data_out.writeFloat((float)par.getPar(t, m));
                        ++m;
                    }
                    ++t;
                }
                data_out.close();
            }
            this.logger.info("saveParam in file: " + fileName);
        }
        catch (IOException e) {
            this.logger.info("IO exception = " + e);
        }
    }

    private void loadMaryXmlF0(HTSUttModel um, HMMData htsData) throws Exception {
        int n;
        this.logger.info("Using f0 from maryXML acoustparams");
        Vector<Double> f0Vector = new Vector<Double>();
        int i = 0;
        while (i < um.getNumUttModel()) {
            HTSModel m = um.getUttModel(i);
            double[] dval = this.getContourSegment(m.getMaryXmlF0(), m.getNumVoiced());
            n = 0;
            while (n < dval.length) {
                f0Vector.add(dval[n]);
                ++n;
            }
            ++i;
        }
        this.interpolateSegments(f0Vector);
        HTSPStream newLf0Pst = new HTSPStream(3, f0Vector.size(), HMMData.FeatureType.LF0, htsData.getMaxLf0GvIter());
        n = 0;
        while (n < f0Vector.size()) {
            newLf0Pst.setPar(n, 0, Math.log(f0Vector.get(n)));
            ++n;
        }
        this.setlf0Pst(newLf0Pst);
    }

    private double[] getContourSegment(String maryXmlF0, int numVoiced) throws Exception {
        double[] f0Vector;
        block7: {
            int t = 0;
            f0Vector = new double[numVoiced];
            int[] cfr_ignored_0 = new int[2];
            double[] cfr_ignored_1 = new double[2];
            if (maryXmlF0 == null) break block7;
            Pattern p = Pattern.compile("(\\d+,\\d+)");
            Matcher xml = p.matcher(maryXmlF0);
            TreeMap<Integer, Double> f0Map = new TreeMap<Integer, Double>();
            int numF0s = 0;
            while (xml.find()) {
                String[] f0Values = xml.group().trim().split(",");
                f0Map.put(new Integer(f0Values[0]), new Double(f0Values[1]));
                ++numF0s;
            }
            Set s = f0Map.entrySet();
            Iterator if0 = s.iterator();
            if (numF0s == numVoiced) {
                t = 0;
                while (if0.hasNext() && t < numVoiced) {
                    Map.Entry mf0 = if0.next();
                    int key = (Integer)mf0.getKey();
                    double valF0 = (Double)mf0.getValue();
                    f0Vector[t++] = valF0;
                }
            } else {
                if (numF0s < numVoiced) {
                    int i = 0;
                    while (i < numVoiced) {
                        f0Vector[i] = 0.0;
                        ++i;
                    }
                }
                while (if0.hasNext() && t < numVoiced) {
                    Map.Entry mf0 = if0.next();
                    int key = (Integer)mf0.getKey();
                    double valF0 = (Double)mf0.getValue();
                    int n = key == 0 ? 0 : (key == 100 ? numVoiced - 1 : (int)((double)(numVoiced * key) / 100.0));
                    if (n < 0 || n >= numVoiced) continue;
                    f0Vector[n] = valF0;
                }
            }
        }
        return f0Vector;
    }

    private void interpolateSegments(Vector<Double> f0) {
        int[] index = new int[2];
        double[] value = new double[2];
        index[0] = 0;
        value[0] = 0.0;
        int i = 0;
        while (i < f0.size()) {
            if (f0.get(i) > 0.0) {
                index[1] = i;
                value[1] = f0.get(i);
                int interval = index[1] - index[0];
                if (interval > 1) {
                    double slope = (value[1] - value[0]) / (double)interval;
                    int n = index[0];
                    while (n < index[1]) {
                        double newVal = slope * (double)(n - index[0]) + value[0];
                        f0.set(n, newVal);
                        ++n;
                    }
                }
                index[0] = index[1];
                value[0] = value[1];
            }
            ++i;
        }
    }

    private void setRealisedF0(HTSPStream lf0Pst, HTSUttModel um, int numStates) {
        int t = 0;
        int vt = 0;
        int i = 0;
        while (i < um.getNumUttModel()) {
            HTSModel m = um.getUttModel(i);
            int numVoicedInModel = m.getNumVoiced();
            String formattedF0 = "";
            int k = 1;
            int state = 0;
            while (state < numStates) {
                int frame = 0;
                while (frame < m.getDur(state)) {
                    if (this.voiced[t++]) {
                        float f0 = (float)Math.exp(lf0Pst.getPar(vt++, 0));
                        formattedF0 = String.valueOf(formattedF0) + "(" + Integer.toString((int)((double)k * 100.0 / (double)numVoicedInModel)) + "," + Integer.toString((int)f0) + ")";
                        ++k;
                    }
                    ++frame;
                }
                ++state;
            }
            if (!formattedF0.contentEquals("")) {
                m.setMaryXmlF0(formattedF0);
            }
            ++i;
        }
    }
}

