/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.de.preprocess;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import marytts.language.de.preprocess.ExpansionPattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TimeEP
extends ExpansionPattern {
    private final String[] _knownTypes = new String[]{"time", "time:hms", "time:hm", "time:h", "time:hms12", "time:hms24"};
    private final List<String> knownTypes = Arrays.asList(this._knownTypes);
    protected final String sHour = "(?:0?[0-9]|1[0-9]|2[0-4])";
    protected final String sHour12 = "(?:0?[0-9]|1[0-2])";
    protected final String sMinute = "(?:[0-5][0-9])";
    protected final String sSecond = "(?:[0-5][0-9])";
    protected final String sSep = "(?:\\:|\\.)";
    protected final String sFinal = "(?:h|Uhr)";
    protected final String sMatchingChars = "[0-9:\\.Uhr]";
    protected final String timeOfDay = "a|A|am|AM|Am|aM|p|P|pm|PM|Pm|pM";
    protected final Pattern reHour = Pattern.compile("((?:0?[0-9]|1[0-9]|2[0-4]))(?:h|Uhr)");
    protected final Pattern reHourMinute = Pattern.compile("((?:0?[0-9]|1[0-9]|2[0-4]))(?:\\:|\\.)((?:[0-5][0-9]))(?:h|Uhr)");
    protected final Pattern reHourMinuteSecond = Pattern.compile("((?:0?[0-9]|1[0-9]|2[0-4]))(?:\\:|\\.)((?:[0-5][0-9]))(?:\\:|\\.)((?:[0-5][0-9]))(?:h|Uhr)");
    private final Pattern reMatchingChars = Pattern.compile("[0-9:\\.Uhr]");

    @Override
    public List<String> knownTypes() {
        return this.knownTypes;
    }

    @Override
    public Pattern reMatchingChars() {
        return this.reMatchingChars;
    }

    @Override
    protected int match(String s, int type) {
        switch (type) {
            case 0: {
                if (this.matchTimeHMS(s)) {
                    return 1;
                }
                if (!this.matchTimeHM(s)) break;
                return 2;
            }
        }
        return -1;
    }

    @Override
    protected int canDealWith(String s, int type) {
        switch (type) {
            case 4: {
                if (!this.canDealWithTimeHMS12(s)) break;
                return 4;
            }
            case 5: {
                if (!this.canDealWithTimeHMS24(s)) break;
                return 5;
            }
        }
        return -1;
    }

    @Override
    protected List<Element> expand(List<Element> tokens, String s, int type) {
        if (tokens == null) {
            throw new NullPointerException("Received null argument");
        }
        if (tokens.isEmpty()) {
            throw new IllegalArgumentException("Received empty list");
        }
        Document doc = tokens.get(0).getOwnerDocument();
        List<Element> expanded = null;
        switch (type) {
            case 1: {
                expanded = this.expandTimeHMS(doc, s);
                break;
            }
            case 2: {
                expanded = this.expandTimeHM(doc, s);
                break;
            }
            case 3: {
                expanded = this.expandTimeH(doc, s);
                break;
            }
            case 4: {
                expanded = this.expandTimeHMS12(doc, s);
                break;
            }
            case 5: {
                expanded = this.expandTimeHMS24(doc, s);
            }
        }
        this.replaceTokens(tokens, expanded);
        return expanded;
    }

    protected boolean matchTimeHMS(String s) {
        return this.reHourMinuteSecond.matcher(s).matches();
    }

    protected boolean matchTimeHM(String s) {
        return this.reHourMinute.matcher(s).matches();
    }

    protected boolean matchTimeH(String s) {
        return this.reHour.matcher(s).matches();
    }

    protected List<Element> expandTimeHMS(Document doc, String s) {
        ArrayList<Element> exp = new ArrayList<Element>();
        StringBuilder sb = new StringBuilder();
        Matcher reMatcher = this.reHourMinuteSecond.matcher(s);
        if (!reMatcher.find()) {
            return null;
        }
        String hour = reMatcher.group(1);
        if (hour.equals("1") || hour.equals("01")) {
            sb.append("ein");
        } else {
            sb.append(number.expandInteger(hour));
        }
        String minute = reMatcher.group(2);
        sb.append(" Uhr");
        if (!minute.equals("00")) {
            sb.append(" ");
            sb.append(number.expandInteger(minute));
        }
        exp.addAll(this.makeNewTokens(doc, sb.toString(), true, s));
        String second = reMatcher.group(3);
        if (!second.equals("00")) {
            exp.addAll(this.makeNewTokens(doc, "und"));
            if (second.equals("01")) {
                exp.addAll(this.makeNewTokens(doc, "eine Sekunde"));
            } else {
                exp.addAll(number.expandInteger(doc, second, false));
                exp.addAll(this.makeNewTokens(doc, "Sekunden"));
            }
        }
        return exp;
    }

    protected List<Element> expandTimeHM(Document doc, String s) {
        ArrayList<Element> exp = new ArrayList<Element>();
        StringBuilder sb = new StringBuilder();
        Matcher reMatcher = this.reHourMinute.matcher(s);
        reMatcher.find();
        String hour = reMatcher.group(1);
        if (hour.equals("1") || hour.equals("01")) {
            sb.append("ein");
        } else {
            sb.append(number.expandInteger(hour));
        }
        String minute = reMatcher.group(2);
        sb.append(" Uhr");
        if (!minute.equals("00")) {
            sb.append(" ");
            sb.append(number.expandInteger(minute));
        }
        exp.addAll(this.makeNewTokens(doc, sb.toString(), true, s));
        return exp;
    }

    protected List<Element> expandTimeH(Document doc, String s) {
        ArrayList<Element> exp = new ArrayList<Element>();
        Matcher reMatcher = this.reHour.matcher(s);
        reMatcher.find();
        String hour = reMatcher.group(1);
        if (hour.equals("1") || hour.equals("01")) {
            exp.addAll(this.makeNewTokens(doc, "ein"));
        } else {
            exp.addAll(number.expandInteger(doc, hour, false));
        }
        exp.addAll(this.makeNewTokens(doc, "Uhr"));
        return exp;
    }

    protected boolean canDealWithTimeHMS12(String s) {
        return this.containsOneOrMoreDigits(s);
    }

    protected boolean canDealWithTimeHMS24(String s) {
        return this.containsOneOrMoreDigits(s);
    }

    protected List<Element> expandTimeHMS12(Document doc, String s) {
        boolean isAfternoon = this.isAfternoon(s);
        if ((s = this.extractDigits(s)).length() == 0) {
            return null;
        }
        if (s.length() % 2 == 1) {
            s = "0" + s;
        }
        if (isAfternoon) {
            if (s.length() > 2) {
                String hours = this.add12Hours(s.substring(0, 2));
                s = String.valueOf(hours) + s.substring(2, s.length());
            } else {
                s = this.add12Hours(s);
            }
        }
        return this.expandTimeHMS12or24(doc, s);
    }

    protected List<Element> expandTimeHMS24(Document doc, String s) {
        if ((s = this.extractDigits(s)).length() == 0) {
            return null;
        }
        if (s.length() % 2 == 1) {
            s = "0" + s;
        }
        return this.expandTimeHMS12or24(doc, s);
    }

    private List<Element> expandTimeHMS12or24(Document doc, String s) {
        int i = s.length() - 1;
        while (i > 1) {
            if (i % 2 == 0) {
                s = String.valueOf(s.substring(0, i)) + ":" + s.substring(i);
            }
            --i;
        }
        s = String.valueOf(s) + "h";
        switch (s.length()) {
            case 3: {
                return this.expandTimeH(doc, s);
            }
            case 6: {
                return this.expandTimeHM(doc, s);
            }
            case 9: {
                return this.expandTimeHMS(doc, s);
            }
        }
        return null;
    }

    private boolean isAfternoon(String s) {
        int i = 0;
        while (i < s.length()) {
            if (s.toLowerCase().charAt(i) == 'p') {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String add12Hours(String s) {
        int iHour = 0;
        if (s.length() == 1) {
            iHour = s.charAt(0) - 32;
            iHour += 12;
        }
        if (s.length() == 2) {
            iHour = s.charAt(1) - 48;
            iHour += (s.charAt(0) - 48) * 10;
            iHour += 12;
        }
        return new Integer(iHour).toString();
    }

    private String extractDigits(String s) {
        StringBuilder sB = new StringBuilder(s);
        int i = 0;
        while (i < sB.length()) {
            if ('0' > sB.charAt(i) || sB.charAt(i) > '9') {
                sB.deleteCharAt(i--);
            }
            ++i;
        }
        return sB.toString();
    }

    private boolean containsOneOrMoreDigits(String s) {
        int i = 0;
        while (i < s.length()) {
            if ('0' <= s.charAt(i) && s.charAt(i) <= '9') {
                return true;
            }
            ++i;
        }
        return false;
    }
}

