/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.de.preprocess;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import marytts.language.de.preprocess.ExpansionPattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SpecialCharEP
extends ExpansionPattern {
    private final String[] _knownTypes = new String[]{"specialChar"};
    private final List<String> knownTypes = Arrays.asList(this._knownTypes);
    private final Map<String, SCEntry> specialCharNames = this.createSpecialCharNames();
    protected final String sMatchingChars = this.createMatchingChars();
    protected final String sMatchingCharsSimpleString = this.createMatchingCharsSimpleString();
    private final String sSplitAtChars = this.createSplitAtChars();
    private final String sSplitAtCharsSimpleString = this.createSplitAtCharsSimpleString();
    private final Pattern reMatchingChars = Pattern.compile(this.sMatchingChars);
    private final Pattern reSplitAtChars = Pattern.compile(this.sSplitAtChars);

    @Override
    public List<String> knownTypes() {
        return this.knownTypes;
    }

    private Map<String, SCEntry> createSpecialCharNames() {
        HashMap<String, SCEntry> m = new HashMap<String, SCEntry>();
        m.put(",", new SCEntry("Komma", false, false));
        m.put("\\", new SCEntry("Backslash['bEk-slES]", true, true));
        m.put("!", new SCEntry("Ausrufezeichen", false, false));
        m.put("#", new SCEntry("Numerical[nu:-'mE-rI_k@l]", true, true));
        m.put("$", new SCEntry("Dollar", false, true));
        m.put(new Character('\u00a7').toString(), new SCEntry("Paragraph", true, true));
        m.put("%", new SCEntry("Prozent", false, true));
        m.put(new Character('\u20ac').toString(), new SCEntry("Euro", false, true));
        m.put("&", new SCEntry("und", true, true));
        m.put("'", new SCEntry("Hochkomma", true, false));
        m.put("*", new SCEntry("Stern", true, true));
        m.put("+", new SCEntry("plus", true, true));
        m.put("-", new SCEntry("Bindestrich", false, false));
        m.put("/", new SCEntry("Slash['slES]", true, false));
        m.put("=", new SCEntry("gleich", true, true));
        m.put("?", new SCEntry("Fragezeichen", true, false));
        m.put("^", new SCEntry("Dach", true, false));
        m.put("_", new SCEntry("Unterstrich", true, false));
        m.put("`", new SCEntry("Hochkomma", true, false));
        m.put("{", new SCEntry("geschweifte Klammer auf", true, false));
        m.put("|", new SCEntry("senkrechter Strich", true, false));
        m.put("}", new SCEntry("geschweifte Klammer zu", true, false));
        m.put("~", new SCEntry("Tilde", true, true));
        m.put("(", new SCEntry("Klammer auf", true, false));
        m.put(")", new SCEntry("Klammer zu", true, false));
        m.put("[", new SCEntry("eckige Klammer auf", true, false));
        m.put("]", new SCEntry("eckige Klammer zu", true, false));
        m.put("@", new SCEntry("at['Et]", false, true));
        m.put(":", new SCEntry("Doppelpunkt", false, false));
        m.put(";", new SCEntry("Semikolon", true, false));
        m.put("\"", new SCEntry("Anf\u00fchrungszeichen", true, false));
        m.put("<", new SCEntry("kleiner als", true, true));
        m.put(">", new SCEntry("gr\u00f6\u00dfer als", true, true));
        m.put(".", new SCEntry("Punkt", false, false));
        return m;
    }

    private String createMatchingChars() {
        StringBuilder sb = new StringBuilder("[");
        Iterator<String> it = this.specialCharNames.keySet().iterator();
        while (it.hasNext()) {
            sb.append("\\" + it.next());
        }
        sb.append("]");
        return sb.toString();
    }

    private String createMatchingCharsSimpleString() {
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = this.specialCharNames.keySet().iterator();
        while (it.hasNext()) {
            sb.append(it.next());
        }
        return sb.toString();
    }

    private String createSplitAtChars() {
        StringBuilder sb = new StringBuilder("[");
        for (String sc : this.specialCharNames.keySet()) {
            if (!this.specialCharNames.get((Object)sc).splitAt) continue;
            sb.append("\\" + sc);
        }
        sb.append("]");
        return sb.toString();
    }

    private String createSplitAtCharsSimpleString() {
        StringBuilder sb = new StringBuilder();
        for (String sc : this.specialCharNames.keySet()) {
            if (!this.specialCharNames.get((Object)sc).splitAt) continue;
            sb.append(sc);
        }
        return sb.toString();
    }

    @Override
    public Pattern reMatchingChars() {
        return this.reMatchingChars;
    }

    protected Pattern getRESplitAtChars() {
        return this.reSplitAtChars;
    }

    protected String splitAtChars() {
        return this.sSplitAtCharsSimpleString;
    }

    @Override
    protected int canDealWith(String s, int type) {
        return this.match(s, type);
    }

    @Override
    protected int match(String s, int type) {
        switch (type) {
            case 0: {
                if (!this.matchSpecialChar(s)) break;
                return 0;
            }
        }
        return -1;
    }

    @Override
    protected List<Element> expand(List<Element> tokens, String s, int type) {
        if (tokens == null) {
            throw new NullPointerException("Received null argument");
        }
        if (tokens.isEmpty()) {
            throw new IllegalArgumentException("Received empty list");
        }
        Document doc = tokens.get(0).getOwnerDocument();
        List<Element> expanded = null;
        switch (type) {
            case 0: {
                expanded = this.expandSpecialChar(doc, s);
            }
        }
        if (expanded != null && !expanded.isEmpty()) {
            this.replaceTokens(tokens, expanded);
        }
        return expanded;
    }

    public boolean matchSpecialChar(String s) {
        return this.reMatchingChars.matcher(s).matches();
    }

    protected boolean doPronounce(String specialChar) {
        SCEntry entry = this.specialCharNames.get(specialChar);
        if (entry == null) {
            return false;
        }
        return entry.pronounce;
    }

    protected List<Element> expandSpecialChar(Document doc, String s) {
        ArrayList<Element> exp = new ArrayList<Element>();
        if (this.doPronounce(s)) {
            String specialCharName = this.expandSpecialChar(s);
            exp.addAll(this.makeNewTokens(doc, specialCharName, true, s));
        }
        return exp;
    }

    protected String expandSpecialChar(String s) {
        SCEntry entry = this.specialCharNames.get(s);
        if (entry == null) {
            return null;
        }
        return entry.expand;
    }

    class SCEntry {
        protected String expand;
        protected boolean splitAt;
        protected boolean pronounce;

        protected SCEntry(String expand, boolean splitAt, boolean pronounce) {
            this.expand = expand;
            this.splitAt = splitAt;
            this.pronounce = pronounce;
        }
    }
}

