/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.de.postlex;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PhonologicalRules {
    private static final String[][] _rules = new String[][]{{"([dlrszSt])@n", "$1@n", "$1@n", "$1@n"}, {"f@n", "f@n", "f@n", "f@n"}, {"g@n", "g@n", "g@n", "g@n"}, {"k@n", "k@n", "k@n", "k@n"}, {"p@n", "p@n", "p@n", "p@n"}, {"x@n", "x@n", "x@n", "x@n"}, {"b@n", "b@n", "b@n", "b@n"}, {"m@n", "m@n", "m@n", "m@n"}, {"n@n", "n@n", "n@n", "n@n"}, {"g-n", "g-n", "g-n", "g-n"}, {"m-b", "m-b", "m-b", "m-b"}, {"t-t", "t-t", "t-t", "t-t"}, {"\\?(aI|OY|aU|[iIyYe\\{E29uUoOaA])", "?$1", "?$1", "?$1"}, {"^([^'-]*)fE6", "$1f6", "$1f6", "$1f6"}, {"-([^'-]*)fE6", "-$1f6", "-$1f6", "-$1f6"}, {"\\?6", "\\?E6", "\\?E6", "\\?E6"}, {"O~:", "a~", "a~", "a~"}, {"o~:", "o~", "o~", "o~"}, {"9~:", "9~", "9~", "9~"}, {"E~:", "e~", "e~", "e~"}, {"O~", "a~", "a~", "a~"}, {"o~", "o~", "o~", "o~"}, {"9~", "9~", "9~", "9~"}, {"E~", "e~", "e~", "e~"}, {"\\{", "E", "E", "E"}};
    private static final List rules = PhonologicalRules.initialiseRules();
    public static final int PRECISE = 1;
    public static final int NORMAL = 2;
    public static final int SLOPPY = 3;
    private Pattern key;
    private String precise;
    private String normal;
    private String sloppy;

    private static List initialiseRules() {
        ArrayList<PhonologicalRules> r = new ArrayList<PhonologicalRules>();
        int i = 0;
        while (i < _rules.length) {
            r.add(new PhonologicalRules(_rules[i]));
            ++i;
        }
        return r;
    }

    public static List getRules() {
        return rules;
    }

    public PhonologicalRules(String[] data) {
        try {
            this.key = Pattern.compile(data[0]);
        }
        catch (PatternSyntaxException e) {
            System.err.println("Cannot compile regular expression `" + data[0] + "':");
            e.printStackTrace();
        }
        this.precise = data[1];
        this.normal = data[2];
        this.sloppy = data[3];
    }

    public boolean matches(String input) {
        return this.key.matcher(input).find();
    }

    public String apply(String input, int precision) {
        String repl = this.normal;
        if (precision == 1) {
            repl = this.precise;
        } else if (precision == 3) {
            repl = this.sloppy;
        }
        return this.key.matcher(input).replaceAll(repl);
    }
}

