/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class StreamUtils {
    public static double[] readDoubleArray(DataInput stream, int len) throws IOException {
        byte[] raw = new byte[len * 64 / 8];
        stream.readFully(raw);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(raw));
        double[] data = new double[len];
        int i = 0;
        while (i < len) {
            data[i] = in.readDouble();
            ++i;
        }
        return data;
    }

    public static void writeDoubleArray(DataOutput stream, double[] data) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        int i = 0;
        while (i < data.length) {
            out.writeDouble(data[i]);
            ++i;
        }
        out.close();
        byte[] raw = baos.toByteArray();
        assert (raw.length == data.length * 64 / 8);
        stream.write(raw);
    }

    public static String readUTF(ByteBuffer bb) throws BufferUnderflowException, UTFDataFormatException {
        int c;
        int utflen = StreamUtils.readUnsignedShort(bb);
        byte[] bytearr = new byte[utflen];
        char[] chararr = new char[utflen];
        int count = 0;
        int chararr_count = 0;
        bb.get(bytearr);
        while (count < utflen) {
            c = bytearr[count] & 0xFF;
            if (c > 127) break;
            ++count;
            chararr[chararr_count++] = (char)c;
        }
        while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException("malformed input around byte " + count);
                }
            }
        }
        return new String(chararr, 0, chararr_count);
    }

    public static int readUnsignedShort(ByteBuffer bb) throws BufferUnderflowException {
        int ch1 = bb.get() & 0xFF;
        int ch2 = bb.get() & 0xFF;
        return (ch1 << 8) + (ch2 << 0);
    }
}

