/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data;

import java.util.LinkedList;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.Datagram;
import marytts.util.data.DoubleDataSource;

public class DatagramDoubleDataSource
extends BufferedDoubleDataSource {
    protected LinkedList<Datagram> datagrams;

    public DatagramDoubleDataSource(Datagram[] datagrams) {
        super((DoubleDataSource)null);
        this.datagrams = new LinkedList();
        this.dataLength = 0L;
        int i = 0;
        while (i < datagrams.length) {
            this.dataLength += datagrams[i].getDuration();
            this.datagrams.add(datagrams[i]);
            ++i;
        }
    }

    public DatagramDoubleDataSource(LinkedList<Datagram> datagrams) {
        super((DoubleDataSource)null);
        this.datagrams = datagrams;
        this.dataLength = 0L;
        for (Datagram d : datagrams) {
            this.dataLength += d.getDuration();
        }
    }

    @Override
    public boolean hasMoreData() {
        return this.currentlyInBuffer() > 0 || !this.datagrams.isEmpty();
    }

    @Override
    public int available() {
        int available = this.currentlyInBuffer();
        for (Datagram d : this.datagrams) {
            available = (int)((long)available + d.getDuration());
        }
        return available;
    }

    @Override
    protected boolean readIntoBuffer(int minLength) {
        if (this.bufferSpaceLeft() < minLength) {
            this.increaseBufferSize(minLength + this.currentlyInBuffer());
        } else if (this.buf.length - this.writePos < minLength) {
            this.compact();
        }
        int readSum = 0;
        while (readSum < minLength && !this.datagrams.isEmpty()) {
            Datagram next = this.datagrams.removeFirst();
            int length = (int)next.getDuration();
            if (this.buf.length < this.writePos + length) {
                this.increaseBufferSize(this.writePos + length);
            }
            int read = this.readDatagram(next, this.buf, this.writePos);
            this.writePos += read;
            readSum += read;
        }
        if (this.dataProcessor != null) {
            this.dataProcessor.applyInline(this.buf, this.writePos - readSum, readSum);
        }
        return readSum >= minLength;
    }

    protected int readDatagram(Datagram d, double[] target, int pos) {
        int dur = (int)d.getDuration();
        byte[] frameAudio = d.getData();
        assert (frameAudio.length / 2 == dur) : "expected datagram data length to be " + dur * 2 + ", found " + frameAudio.length;
        int i = 0;
        while (i < frameAudio.length) {
            byte lobyte = frameAudio[i + 1];
            byte hibyte = frameAudio[i];
            int sample = hibyte << 8 | lobyte & 0xFF;
            target[pos] = (double)sample / 32768.0;
            i += 2;
            ++pos;
        }
        return dur;
    }
}

