/*
 * Decompiled with CFR 0.152.
 */
package marytts.tools.emospeak;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.Vector;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.client.MaryClient;
import marytts.tools.emospeak.AudioFileReceiver;
import marytts.util.http.Address;

public class AsynchronousThreadedMaryClient
extends Thread {
    private int r;
    private AudioFileReceiver emoSpeak;
    private MaryClient processor;
    private boolean inputAvailable = false;
    private String latestRequest = null;
    private MaryClient.Voice latestRequestVoice = null;
    private AudioInputStream latestAudio = null;
    private boolean exitRequested = false;

    public AsynchronousThreadedMaryClient(AudioFileReceiver emoSpeak) throws IOException, UnknownHostException {
        this.emoSpeak = emoSpeak;
        this.processor = MaryClient.getMaryClient();
    }

    public AsynchronousThreadedMaryClient(AudioFileReceiver emoSpeak, String serverHost, int serverPort, boolean printProfilingInfo, boolean beQuiet) throws IOException, UnknownHostException {
        this.emoSpeak = emoSpeak;
        this.processor = MaryClient.getMaryClient(new Address(serverHost, serverPort), printProfilingInfo, beQuiet);
    }

    public synchronized void scheduleRequest(String prosodyxmlString, MaryClient.Voice voice, int requestNumber) {
        this.latestRequest = prosodyxmlString;
        this.latestRequestVoice = voice;
        this.inputAvailable = true;
        this.r = requestNumber;
        this.notifyAll();
    }

    public synchronized void requestExit() {
        this.exitRequested = true;
        this.notifyAll();
    }

    private void processInput() throws IOException, UnknownHostException, UnsupportedAudioFileException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        assert (this.latestRequestVoice != null);
        this.processor.process(this.latestRequest, "RAWMARYXML", "AUDIO", this.latestRequestVoice.getLocale().toString(), "AU", this.latestRequestVoice.name(), os);
        byte[] bytes = os.toByteArray();
        this.latestAudio = AudioSystem.getAudioInputStream(new ByteArrayInputStream(bytes));
    }

    public String getHost() {
        return this.processor.getHost();
    }

    public int getPort() {
        return this.processor.getPort();
    }

    public Vector getServerVoices() throws IOException {
        return this.processor.getGeneralDomainVoices();
    }

    public Vector getServerVoices(Locale locale) throws IOException {
        return this.processor.getGeneralDomainVoices(locale);
    }

    private synchronized void doWait() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public void run() {
        while (!this.exitRequested) {
            if (this.inputAvailable) {
                try {
                    AsynchronousThreadedMaryClient.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
                this.inputAvailable = false;
                int r1 = this.r;
                long t0 = System.currentTimeMillis();
                try {
                    this.processInput();
                    long t = System.currentTimeMillis() - t0;
                    System.err.println("MaryClient has processed request no." + r1 + " in " + t + " ms.");
                    this.emoSpeak.setNextAudio(this.latestAudio);
                }
                catch (Exception e) {
                    System.err.println("Problem creating synthesis audio:");
                    e.printStackTrace();
                    this.emoSpeak.setNextAudio(null);
                }
                continue;
            }
            this.doWait();
            System.err.println("MaryClient waking up from wait.");
        }
        System.err.println("MaryClient exiting.");
    }
}

