/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.hntm.analysis;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import marytts.signalproc.sinusoidal.hntm.analysis.FrameNoisePart;
import marytts.util.math.ArrayUtils;

public class FrameNoisePartWaveform
implements FrameNoisePart {
    protected short[] waveform = null;

    public FrameNoisePartWaveform() {
    }

    public FrameNoisePartWaveform(FrameNoisePartWaveform existing) {
        this();
        this.waveform = ArrayUtils.copy(existing.waveform);
    }

    public FrameNoisePartWaveform(DataInputStream dis, int waveLen) {
        this();
        if (waveLen > 0) {
            this.waveform = new short[waveLen];
            int i = 0;
            while (i < waveLen) {
                try {
                    this.waveform[i] = dis.readShort();
                }
                catch (IOException iOException) {
                    System.out.println("Error! At least " + String.valueOf(waveLen) + " samples required!");
                }
                ++i;
            }
        }
    }

    public FrameNoisePartWaveform(ByteBuffer bb, int waveLen) {
        this();
        if (waveLen > 0) {
            this.waveform = new short[waveLen];
            int i = 0;
            while (i < waveLen) {
                try {
                    this.waveform[i] = bb.getShort();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("At least " + String.valueOf(waveLen) + " samples required!", e);
                }
                ++i;
            }
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        int waveLen = 0;
        if (this.waveform != null && this.waveform.length > 0) {
            waveLen = this.waveform.length;
        }
        if (waveLen > 0) {
            int i = 0;
            while (i < this.waveform.length) {
                out.writeShort(this.waveform[i]);
                ++i;
            }
        }
    }

    public FrameNoisePartWaveform(float[] x) {
        this();
        this.setWaveform(x);
    }

    public FrameNoisePartWaveform(double[] x) {
        this();
        this.setWaveform(x);
    }

    public FrameNoisePartWaveform(short[] x) {
        this();
        this.setWaveform(x);
    }

    public boolean equals(FrameNoisePartWaveform other) {
        if (this.waveform != null || other.waveform != null) {
            if (this.waveform != null && other.waveform == null) {
                return false;
            }
            if (this.waveform == null && other.waveform != null) {
                return false;
            }
            if (this.waveform.length != other.waveform.length) {
                return false;
            }
            if (this.waveform != null) {
                int i = 0;
                while (i < this.waveform.length) {
                    if (this.waveform[i] != other.waveform[i]) {
                        return false;
                    }
                    ++i;
                }
            }
        }
        return true;
    }

    @Override
    public int getVectorSize() {
        int waveLen = 0;
        if (this.waveform != null && this.waveform.length > 0) {
            waveLen = this.waveform.length;
        }
        return waveLen;
    }

    @Override
    public int getLength() {
        return 2 * this.getVectorSize();
    }

    public void setWaveform(float[] x) {
        this.waveform = (short[])(x != null ? ArrayUtils.copyFloat2Short(x) : null);
    }

    public void setWaveform(double[] x) {
        this.waveform = (short[])(x != null ? ArrayUtils.copyDouble2Short(x) : null);
    }

    public void setWaveform(short[] x) {
        this.waveform = (short[])(x != null ? ArrayUtils.copy(x) : null);
    }

    public double[] waveform2Doubles() {
        if (this.waveform != null) {
            return ArrayUtils.copyShort2Double(this.waveform);
        }
        return null;
    }

    public float[] waveform2Floats() {
        if (this.waveform != null) {
            return ArrayUtils.copyShort2Float(this.waveform);
        }
        return null;
    }

    public short[] waveform() {
        return this.waveform;
    }
}

