/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.analysis.LpcAnalyser;
import marytts.signalproc.filter.FIRFilter;
import marytts.signalproc.filter.RecursiveFilter;
import marytts.signalproc.process.FrameOverlapAddSource;
import marytts.signalproc.process.InlineDataProcessor;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.math.ArrayUtils;

public class LPCAnalysisResynthesis
implements InlineDataProcessor {
    protected int p;

    public LPCAnalysisResynthesis(int p) {
        this.p = p;
    }

    @Override
    public void applyInline(double[] data, int off, int len) {
        assert (off == 0);
        assert (len == data.length);
        LpcAnalyser.LpCoeffs coeffs = LpcAnalyser.calcLPC(data, this.p);
        double[] residual = ArrayUtils.subarray(new FIRFilter(coeffs.getOneMinusA()).apply(data), 0, len);
        this.processLPC(coeffs, residual);
        double[] newData = new RecursiveFilter(coeffs.getA()).apply(residual);
        System.arraycopy(newData, 0, data, 0, len);
    }

    protected void processLPC(LpcAnalyser.LpCoeffs coeffs, double[] residual) {
    }

    public static void main(String[] args) throws Exception {
        int i = 0;
        while (i < args.length) {
            AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[i]));
            int samplingRate = (int)inputAudio.getFormat().getSampleRate();
            AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
            int frameLength = Integer.getInteger("signalproc.lpcanalysissynthesis.framelength", 512);
            int predictionOrder = Integer.getInteger("signalproc.lpcanalysissynthesis.predictionorder", 20);
            FrameOverlapAddSource foas = new FrameOverlapAddSource(signal, 3, true, frameLength, samplingRate, new LPCAnalysisResynthesis(predictionOrder));
            DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(foas), inputAudio.getFormat());
            String outFileName = String.valueOf(args[i].substring(0, args[i].length() - 4)) + "_lpc_ar.wav";
            AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
            ++i;
        }
    }
}

