/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import marytts.signalproc.analysis.RegularizedCepstrumEstimator;
import marytts.util.math.ArrayUtils;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class RegularizedPostWarpedCepstrumEstimator
extends RegularizedCepstrumEstimator {
    public static int getAutoCepsOrderPre(int numSpectralLines) {
        if (numSpectralLines <= 0) {
            return 40;
        }
        return numSpectralLines * 2;
    }

    public static float[] freqsLinearAmps2cepstrum(double[] linearAmps, double[] freqsInHz, int samplingRateInHz, int cepsOrderPre, int cepsOrder) {
        return RegularizedPostWarpedCepstrumEstimator.freqsLinearAmps2cepstrum(linearAmps, freqsInHz, samplingRateInHz, cepsOrderPre, cepsOrder, null);
    }

    public static float[] freqsLinearAmps2cepstrum(double[] linearAmps, double[] freqsInHz, int samplingRateInHz, int cepsOrderPre, int cepsOrder, double[] weights) {
        return RegularizedPostWarpedCepstrumEstimator.freqsLinearAmps2cepstrum(linearAmps, freqsInHz, samplingRateInHz, cepsOrderPre, cepsOrder, weights, 5.0E-4);
    }

    public static float[] freqsLinearAmps2cepstrum(double[] linearAmps, double[] freqsInHz, int samplingRateInHz, int cepsOrderPre, int cepsOrder, double[] weights, double lambda) {
        if (cepsOrderPre < 1) {
            cepsOrderPre = RegularizedPostWarpedCepstrumEstimator.getAutoCepsOrderPre(linearAmps.length);
        }
        float[] ceps = RegularizedPostWarpedCepstrumEstimator.freqsLinearAmps2cepstrum(linearAmps, freqsInHz, samplingRateInHz, cepsOrderPre, false, weights, lambda);
        double[][] A = new double[cepsOrder][cepsOrderPre];
        int N = cepsOrderPre;
        int k = 0;
        while (k < cepsOrder) {
            int l = 0;
            while (l < cepsOrderPre) {
                A[k][l] = 0.0;
                int n = 0;
                while (n < N) {
                    double w = SignalProcUtils.mel2radian(Math.PI * (double)n / (double)N, samplingRateInHz);
                    double[] dArray = A[k];
                    int n2 = l;
                    dArray[n2] = dArray[n2] + Math.cos((double)l * w) * Math.cos(Math.PI * (double)n * (double)k / (double)N);
                    ++n;
                }
                if (l == 0) {
                    double[] dArray = A[k];
                    int n3 = l;
                    dArray[n3] = dArray[n3] * (1.0 / (double)N);
                } else {
                    double[] dArray = A[k];
                    int n4 = l;
                    dArray[n4] = dArray[n4] * (2.0 / (double)N);
                }
                ++l;
            }
            ++k;
        }
        double[] cepsDouble = MathUtils.matrixProduct(A, ceps);
        ceps = ArrayUtils.copyDouble2Float(cepsDouble);
        return ceps;
    }

    public static float[] freqsLinearAmps2cepstrum(double[] linearAmps, double[] freqsInHz, int samplingRateInHz, int cepsOrder, double[] weights, double lambda) {
        return RegularizedPostWarpedCepstrumEstimator.freqsLinearAmps2cepstrum(linearAmps, freqsInHz, samplingRateInHz, cepsOrder, false, weights, lambda);
    }

    public static double[] spectralEnvelopeDB(double[] linearAmps, double[] freqsInHz, int samplingRateInHz, int cepsOrder, int fftSize) {
        float[] ceps = RegularizedPostWarpedCepstrumEstimator.freqsLinearAmps2cepstrum(linearAmps, freqsInHz, samplingRateInHz, cepsOrder);
        return RegularizedPostWarpedCepstrumEstimator.cepstrum2logAmpHalfSpectrum(ceps, fftSize, samplingRateInHz);
    }

    public static float[] freqsLinearAmps2cepstrum(double[] linearAmps, double[] freqsInHz, int samplingRateInHz, int cepsOrder) {
        return RegularizedPostWarpedCepstrumEstimator.freqsLinearAmps2cepstrum(linearAmps, freqsInHz, samplingRateInHz, cepsOrder, false, null, 5.0E-4);
    }

    public static double[] cepstrum2logAmpHalfSpectrum(float[] ceps, int fftSize, int samplingRateInHz) {
        return RegularizedPostWarpedCepstrumEstimator.cepstrum2logAmpHalfSpectrum(ceps, fftSize, samplingRateInHz, false);
    }

    public static double[] cepstrum2linearSpectrumValues(float[] ceps, int maxFreqIndex, int samplingRateInHz) {
        double[] freqsInHz = new double[maxFreqIndex];
        int i = 0;
        while (i <= maxFreqIndex) {
            freqsInHz[i] = SignalProcUtils.index2freq(i, samplingRateInHz, maxFreqIndex);
            ++i;
        }
        return RegularizedPostWarpedCepstrumEstimator.cepstrum2linearSpectrumValues(ceps, freqsInHz, samplingRateInHz);
    }

    public static double[] cepstrum2linearSpectrumValues(float[] ceps, double[] freqsInHz, int samplingRateInHz) {
        return MathUtils.db2amp(RegularizedPostWarpedCepstrumEstimator.cepstrum2dbSpectrumValues(ceps, freqsInHz, samplingRateInHz));
    }

    public static double[] cepstrum2dbSpectrumValues(float[] ceps, int maxFreqIndex, int samplingRateInHz) {
        double[] freqsInHz = new double[maxFreqIndex + 1];
        int i = 0;
        while (i <= maxFreqIndex) {
            freqsInHz[i] = SignalProcUtils.index2freq(i, samplingRateInHz, maxFreqIndex);
            ++i;
        }
        return RegularizedPostWarpedCepstrumEstimator.cepstrum2dbSpectrumValues(ceps, freqsInHz, samplingRateInHz);
    }

    public static double[] cepstrum2dbSpectrumValues(float[] ceps, double[] freqsInHz, int samplingRateInHz) {
        double[] vals = new double[freqsInHz.length];
        int i = 0;
        while (i < freqsInHz.length) {
            vals[i] = RegularizedPostWarpedCepstrumEstimator.cepstrum2dbSpectrumValue(ceps, freqsInHz[i], samplingRateInHz);
            ++i;
        }
        return vals;
    }

    public static double[][] precomputeM(double[] freqsInHz, int samplingRateInHz, int cepsOrder) {
        return RegularizedPostWarpedCepstrumEstimator.precomputeM(freqsInHz, samplingRateInHz, cepsOrder, false);
    }

    public static double cepstrum2dbSpectrumValue(float[] ceps, double freqInHz, int samplingRateInHz) {
        int p = ceps.length - 1;
        double w = SignalProcUtils.hz2mel(freqInHz, samplingRateInHz);
        double val = ceps[0];
        int i = 1;
        while (i <= p) {
            val += 2.0 * (double)ceps[i] * Math.cos(w * (double)i);
            ++i;
        }
        return val;
    }

    public static double[] spectralEnvelopeLinear(double[] linearAmps, double[] freqsInHz, int samplingRateInHz, int cepsOrderPre, int cepsOrder) {
        return RegularizedPostWarpedCepstrumEstimator.spectralEnvelopeLinear(linearAmps, freqsInHz, samplingRateInHz, cepsOrderPre, cepsOrder, SignalProcUtils.getDFTSize(samplingRateInHz));
    }

    public static double[] spectralEnvelopeLinear(double[] linearAmps, double[] freqsInHz, int samplingRateInHz, int cepsOrderPre, int cepsOrder, int fftSize) {
        return MathUtils.db2amp(RegularizedPostWarpedCepstrumEstimator.spectralEnvelopeDB(linearAmps, freqsInHz, samplingRateInHz, cepsOrderPre, cepsOrder, fftSize));
    }

    public static double[] spectralEnvelopeDB(double[] linearAmps, double[] freqsInHz, int samplingRateInHz, int cepsOrderPre, int cepsOrder, int fftSize) {
        float[] ceps = RegularizedPostWarpedCepstrumEstimator.freqsLinearAmps2cepstrum(linearAmps, freqsInHz, samplingRateInHz, cepsOrderPre, cepsOrder);
        return RegularizedPostWarpedCepstrumEstimator.cepstrum2logAmpHalfSpectrum(ceps, fftSize, samplingRateInHz);
    }

    public static double cepstrum2linearSpectrumValue(float[] ceps, double freqInHz, int samplingRateInHz) {
        return MathUtils.db2amp(RegularizedPostWarpedCepstrumEstimator.cepstrum2dbSpectrumValue(ceps, freqInHz, samplingRateInHz));
    }
}

